/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.assertion;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.gateway.SecurityDomainRegistry;
import org.josso.gateway.assertion.AssertionManager;
import org.josso.gateway.assertion.AuthenticationAssertion;
import org.josso.gateway.assertion.AuthenticationAssertionImpl;
import org.josso.gateway.assertion.service.AssertionIdGenerator;
import org.josso.gateway.assertion.service.store.AssertionStore;

public class AssertionManagerImpl
implements AssertionManager {
    private static final Log logger = LogFactory.getLog(AssertionManagerImpl.class);
    private String securityDomainName;
    private AssertionMonitor _monitor;
    private Thread _monitorThread;
    private AssertionStore _assertionStore;
    private AssertionIdGenerator _assertionIdGenerator;
    private long _assertionMonitorInterval = 5000L;

    public void initialize() {
        this._monitor = new AssertionMonitor(this, this.getAssertionMonitorInterval());
        this._monitorThread = new Thread(this._monitor);
        this._monitorThread.setDaemon(true);
        this._monitorThread.setName("JOSSOAssertionMonitor");
        this._monitorThread.start();
    }

    public void destroy() {
        if (this._monitor != null) {
            this._monitor.stop();
            try {
                this._monitorThread.join();
            }
            catch (InterruptedException e) {
                logger.warn((Object)"[destroy()] : main thread interrupted.");
            }
        }
    }

    public void setSecurityDomainName(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }

    public void setAssertionStore(AssertionStore as) {
        this._assertionStore = as;
    }

    public void setAssertionIdGenerator(AssertionIdGenerator assertionIdGenerator) {
        this._assertionIdGenerator = assertionIdGenerator;
    }

    public String getSecurityDomainName() {
        return this.securityDomainName;
    }

    public long getAssertionMonitorInterval() {
        return this._assertionMonitorInterval;
    }

    public void setAssertionMonitorInterval(long assertionMonitorInterval) {
        this._assertionMonitorInterval = assertionMonitorInterval;
        if (this._monitor != null) {
            this._monitor.setInterval(this._assertionMonitorInterval);
        }
    }

    public synchronized AuthenticationAssertion requestAssertion(String ssoSessionId) {
        try {
            AuthenticationAssertionImpl assertion = new AuthenticationAssertionImpl(this._assertionIdGenerator.generateId(), ssoSessionId);
            SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
            this._assertionStore.save((AuthenticationAssertion)assertion);
            registry.registerToken(this.securityDomainName, TOKEN_TYPE, assertion.getId());
            return assertion;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized AuthenticationAssertion consumeAssertion(String assertionId) {
        AuthenticationAssertion targetAuthenticationAssertion = null;
        try {
            AuthenticationAssertion[] assertions;
            SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
            for (AuthenticationAssertion aa : assertions = this._assertionStore.loadAll()) {
                if (!aa.getId().equals(assertionId)) continue;
                targetAuthenticationAssertion = aa;
                this._assertionStore.remove(aa.getId());
                registry.unregisterToken(this.securityDomainName, TOKEN_TYPE, aa.getId());
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return targetAuthenticationAssertion;
    }

    public void checkPendingAssertions() {
        try {
            AuthenticationAssertion[] assertions;
            SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
            for (AuthenticationAssertion assertion : assertions = this._assertionStore.loadAll()) {
                try {
                    if (assertion.isValid()) continue;
                    this._assertionStore.remove(assertion.getId());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("[checkPendingAssertions()] Assertion expired : " + assertion.getId()));
                }
                catch (Exception e) {
                    logger.warn((Object)("Can't remove assertion " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot check pending assertions! " + e.getMessage()), (Throwable)e);
        }
    }

    private class AssertionMonitor
    implements Runnable {
        private long _interval;
        private AssertionManager _m;
        private boolean _stop;

        AssertionMonitor(AssertionManager m) {
            this._m = m;
        }

        AssertionMonitor(AssertionManager m, long interval) {
            this._interval = interval;
            this._m = m;
        }

        public long getInterval() {
            return this._interval;
        }

        public void setInterval(long interval) {
            this._interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._stop = false;
            do {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"[run()] calling checkPendingAssertions ... ");
                    }
                    this._m.checkPendingAssertions();
                    AssertionMonitor assertionMonitor = this;
                    synchronized (assertionMonitor) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("[run()] waiting " + this._interval + " ms"));
                            }
                            this.wait(this._interval);
                        }
                        catch (InterruptedException e) {
                            logger.warn((Object)e, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception received : " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
                }
            } while (!this._stop);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this._stop = true;
            AssertionMonitor assertionMonitor = this;
            synchronized (assertionMonitor) {
                this.notify();
            }
        }
    }
}

