/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.audit.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.audit.SSOAuditManager;
import org.josso.gateway.audit.SSOAuditTrail;
import org.josso.gateway.audit.exceptions.SSOAuditException;
import org.josso.gateway.audit.service.BaseSSOAuditTrail;
import org.josso.gateway.audit.service.handler.SSOAuditTrailHandler;
import org.josso.gateway.event.BaseSSOEvent;
import org.josso.gateway.event.SSOEvent;
import org.josso.gateway.event.SSOEventListener;
import org.josso.gateway.event.security.SSOIdentityEvent;
import org.josso.gateway.event.security.SSOSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOAuditManagerImpl
implements SSOAuditManager,
SSOEventListener {
    private static final Log logger = LogFactory.getLog(SSOAuditManagerImpl.class);
    public static final String OUTCOME_SUCCESS = "success";
    public static final String OUTCOME_FAILURE = "failure";
    private String _name;
    protected List handlers = new ArrayList();

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public List<SSOAuditTrailHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<SSOAuditTrailHandler> handlers) {
        this.handlers = handlers;
    }

    public void addHandler(SSOAuditTrailHandler handler) {
        logger.info((Object)("Adding handler : " + handler.getClass().getName()));
        this.handlers.add(handler);
    }

    public void handleSSOEvent(SSOEvent event) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("handling sso event : " + event));
            }
            SSOAuditTrail auditTrail = this.buildAuditTrail(event);
            this.processAuditTrail(auditTrail);
        }
        catch (Exception e) {
            logger.error((Object)("Can't generate audit : " + e.getMessage()), (Throwable)e);
        }
    }

    public void processAuditTrail(SSOAuditTrail trail) throws SSOAuditException {
        for (int i = 0; i < this.handlers.size(); ++i) {
            SSOAuditTrailHandler handler = (SSOAuditTrailHandler)this.handlers.get(i);
            if (handler.handle(trail) != 0) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("Process interrupted by : " + handler));
            break;
        }
    }

    protected SSOAuditTrail buildAuditTrail(SSOEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating Audit Trail form SSO event");
        }
        String category = null;
        String severity = "info";
        String subject = null;
        String outcome = null;
        Throwable error = null;
        Date time = new Date();
        String action = event.getType();
        if (event instanceof BaseSSOEvent) {
            error = ((BaseSSOEvent)event).getError();
            outcome = error != null ? OUTCOME_FAILURE : OUTCOME_SUCCESS;
        }
        Properties props = new Properties();
        if (event instanceof SSOIdentityEvent) {
            category = "sso-user";
            SSOIdentityEvent ie = (SSOIdentityEvent)event;
            subject = ((SSOIdentityEvent)event).getUsername();
            if (ie.getRemoteHost() != null) {
                props.setProperty("remoteHost", ie.getRemoteHost());
            }
            if (ie.getScheme() != null) {
                props.setProperty("authScheme", ie.getScheme());
            }
            if (ie.getSessionId() != null) {
                props.setProperty("ssoSessionId", ie.getSessionId());
            }
        } else if (event instanceof SSOSessionEvent) {
            category = "sso-session";
            SSOSessionEvent se = (SSOSessionEvent)event;
            subject = se.getUsername();
            props.setProperty("ssoSessionId", se.getSessionId());
            if (se.getData() != null) {
                props.setProperty("data", se.getData().toString());
            }
        }
        return new BaseSSOAuditTrail(category, severity, subject, action, outcome, time, props, error);
    }
}

