/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.SecurityDomain;
import org.josso.auth.Authenticator;
import org.josso.auth.Credential;
import org.josso.auth.SimplePrincipal;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.MutableSSOContext;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOException;
import org.josso.gateway.assertion.AssertionManager;
import org.josso.gateway.assertion.AuthenticationAssertion;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.event.security.SSOSecurityEventManager;
import org.josso.gateway.identity.exceptions.IdentityProvisioningException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManager;
import org.josso.gateway.identity.service.SSOIdentityProvider;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.SSOSessionManager;

public class SSOIdentityProviderImpl
implements SSOIdentityProvider {
    private static final Log logger = LogFactory.getLog(SSOIdentityProvider.class);

    public void initialize() {
    }

    public String assertIdentityWithSimpleAuthentication(String username, String password) throws IdentityProvisioningException {
        try {
            Credential cUsername = null;
            Credential cPassword = null;
            cUsername = this.newCredential("basic-authentication", "username", username);
            cPassword = this.newCredential("basic-authentication", "password", password);
            Credential[] c = new Credential[]{cUsername, cPassword};
            SSOSession userSsoSession = this.login(c, "basic-authentication");
            AssertionManager am = Lookup.getInstance().lookupAssertionManager();
            AuthenticationAssertion aa = am.requestAssertion(userSsoSession.getId());
            return aa.getId();
        }
        catch (SSOAuthenticationException e) {
            throw new IdentityProvisioningException("Failed to assert identity of user : " + username);
        }
        catch (SSOException e) {
            throw new IdentityProvisioningException("Error asserting identity of user : " + username);
        }
        catch (Exception e) {
            throw new IdentityProvisioningException("Unknown error asserting identity of user : " + username);
        }
    }

    public String resolveAuthenticationAssertion(String authenticationAssertionId) throws IdentityProvisioningException {
        try {
            AssertionManager am = Lookup.getInstance().lookupAssertionManager();
            AuthenticationAssertion aa = am.consumeAssertion(authenticationAssertionId);
            if (aa == null) {
                throw new AssertionNotValidException(authenticationAssertionId);
            }
            return aa.getSSOSessionId();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IdentityProvisioningException("Error dereferencing authentication assertion : " + authenticationAssertionId, e);
        }
    }

    public void globalSignoff(String sessionId) throws IdentityProvisioningException {
        try {
            MutableSSOContext ctx = (MutableSSOContext)SSOContext.getCurrent();
            SecurityDomain domain = ctx.getSecurityDomain();
            SSOSessionManager sm = domain.getSessionManager();
            SSOSession session = sm.getSession(sessionId);
            ctx.setCurrentSession(session);
            ctx.setUserLocation("remote-application");
            ctx.setScheme("basic-authentication");
            this.logout();
        }
        catch (SSOException e) {
            throw new IdentityProvisioningException("Error signing off user with sessin : " + sessionId);
        }
        catch (Exception e) {
            throw new IdentityProvisioningException("Unknown error signing off user with session : " + sessionId);
        }
    }

    public SSOSession login(Credential[] cred, String scheme) throws SSOException, SSOAuthenticationException {
        SSOContext ctx = SSOContext.getCurrent();
        try {
            Subject s;
            Set<SimplePrincipal> principals;
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            SSOIdentityManager im = domain.getIdentityManager();
            SSOSessionManager sm = domain.getSessionManager();
            Authenticator au = domain.getAuthenticator();
            SSOSession currentSession = ctx.getSession();
            if (currentSession != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invalidating existing session : " + currentSession.getId()));
                    }
                    sm.invalidate(currentSession.getId());
                }
                catch (Exception e) {
                    logger.warn((Object)("Can't ivalidate current session : " + currentSession.getId() + "\n" + e.getMessage()), (Throwable)e);
                }
            }
            if ((principals = (s = au.check(cred, scheme)).getPrincipals(SimplePrincipal.class)).size() != 1) {
                throw new SSOException("Assertion failed : principals.size() != 1");
            }
            Principal p = (Principal)principals.iterator().next();
            im.userExists(p.getName());
            String ssoSessionId = sm.initiateSession(p.getName());
            SSOSession session = sm.getSession(ssoSessionId);
            this.notifyLoginSuccess(session.getUsername(), session, scheme);
            return session;
        }
        catch (AuthenticationFailureException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this.notifyLoginFailed(cred, scheme, e);
            throw e;
        }
        catch (SSOAuthenticationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this.notifyLoginFailed(cred, scheme, e);
            throw e;
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this.notifyLoginFailed(cred, scheme, e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
        catch (SSOSessionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this.notifyLoginFailed(cred, scheme, e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.notifyLoginFailed(cred, scheme, e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
    }

    public AuthenticationAssertion assertIdentity(Credential[] credentials, String scheme) throws SSOException, SSOAuthenticationException {
        SSOContext ctx = SSOContext.getCurrent();
        try {
            SSOSession session = this.login(credentials, scheme);
            AssertionManager assertionManager = Lookup.getInstance().lookupAssertionManager();
            return assertionManager.requestAssertion(session.getId());
        }
        catch (AuthenticationFailureException e) {
            throw e;
        }
        catch (SSOAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
    }

    public AuthenticationAssertion assertIdentity(String sessionId) throws SSOException {
        try {
            SSOSessionManager sm = Lookup.getInstance().lookupSecurityDomain().getSessionManager();
            AssertionManager assertionManager = Lookup.getInstance().lookupAssertionManager();
            SSOSession session = sm.getSession(sessionId);
            return assertionManager.requestAssertion(session.getId());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
    }

    public void logout() throws SSOException {
        SSOContext ctx = SSOContext.getCurrent();
        SSOSession session = ctx.getSession();
        if (session == null) {
            return;
        }
        String ssoSessionId = session.getId();
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            SSOSessionManager sm = domain.getSessionManager();
            sm.invalidate(ssoSessionId);
            this.notifyLogoutSuccess(session);
        }
        catch (NoSuchSessionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[logout()] Session is not valid : " + ssoSessionId));
            }
        }
        catch (SSOSessionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.notifyLogoutFail(e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.notifyLogoutFail(e);
            throw new SSOException(e.getMessage(), (Throwable)e);
        }
    }

    protected void notifyLoginFailed(Credential[] credentials, String scheme, Throwable error) {
        SSOContext ctx = SSOContext.getCurrent();
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireAuthenticationFailureEvent(ctx.getUserLocation(), scheme, credentials, error);
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify login failure : " + e.getMessage()), (Throwable)e);
        }
    }

    protected void notifyLoginSuccess(String username, SSOSession session, String scheme) {
        SSOContext ctx = SSOContext.getCurrent();
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireAuthenticationSuccessEvent(ctx.getUserLocation(), scheme, username, session.getId());
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify login success : " + e.getMessage()), (Throwable)e);
        }
    }

    private void notifyLogoutFail(Throwable error) {
        SSOContext ctx = SSOContext.getCurrent();
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireLogoutFailureEvent(ctx.getUserLocation(), ctx.getSession().getUsername(), ctx.getSession().getId(), error);
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify logout failure : " + e.getMessage()), (Throwable)e);
        }
    }

    protected void notifyLogoutSuccess(SSOSession session) {
        SSOContext ctx = SSOContext.getCurrent();
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireLogoutSuccessEvent(ctx.getUserLocation(), session.getUsername(), session.getId());
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify logout success : " + e.getMessage()), (Throwable)e);
        }
    }

    protected Credential newCredential(String schemeName, String name, Object value) throws SSOAuthenticationException {
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            Authenticator au = domain.getAuthenticator();
            return au.newCredential(schemeName, name, value);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

