/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password.generator;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.SSOUser;
import org.josso.selfservices.ChallengeResponseCredential;
import org.josso.selfservices.password.PasswordGenerator;
import org.josso.selfservices.password.generator.IPasswordFilter;
import org.josso.selfservices.password.generator.IPwGenCommandLineOptions;
import org.josso.selfservices.password.generator.IPwGenConstants;
import org.josso.selfservices.password.generator.IPwGenRegEx;
import org.josso.selfservices.password.generator.IRandomFactory;
import org.josso.selfservices.password.generator.Messages;
import org.josso.selfservices.password.generator.PwElement;
import org.josso.selfservices.password.generator.RandomFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordGeneratorImpl
implements IPwGenConstants,
IPwGenCommandLineOptions,
IPwGenRegEx,
PasswordGenerator {
    private static final Log log = LogFactory.getLog(PasswordGeneratorImpl.class);
    private static final PwElement[] PW_ELEMENTS = new PwElement[]{new PwElement("a", 2), new PwElement("ae", 6), new PwElement("ah", 6), new PwElement("ai", 6), new PwElement("b", 1), new PwElement("c", 1), new PwElement("ch", 5), new PwElement("d", 1), new PwElement("e", 2), new PwElement("ee", 6), new PwElement("ei", 6), new PwElement("f", 1), new PwElement("g", 1), new PwElement("gh", 13), new PwElement("h", 1), new PwElement("i", 2), new PwElement("ie", 6), new PwElement("j", 1), new PwElement("k", 1), new PwElement("l", 1), new PwElement("m", 1), new PwElement("n", 1), new PwElement("ng", 13), new PwElement("o", 2), new PwElement("oh", 6), new PwElement("oo", 6), new PwElement("p", 1), new PwElement("ph", 5), new PwElement("qu", 5), new PwElement("r", 1), new PwElement("s", 1), new PwElement("sh", 5), new PwElement("t", 1), new PwElement("th", 5), new PwElement("u", 2), new PwElement("v", 1), new PwElement("w", 1), new PwElement("x", 1), new PwElement("y", 1), new PwElement("z", 1)};
    private Random random;
    private Map<String, IPasswordFilter> filters = new HashMap<String, IPasswordFilter>();
    private static int DEFAULT_MAX_ATTEMPTS = 10000;
    private IRandomFactory randomFactory;
    private int passwordFlags = 0;
    private int passwordLength = 8;
    private boolean useSimpleRandom;
    private String secureRandomAlgorithm;
    private String secureRandomProvider;
    private boolean generateNumerals;
    private boolean generateCapitalLetters;
    private boolean includeAmbigousChars;
    private boolean includeSpecialSymbols;
    private boolean regexStartsNoSmallLetter;
    private boolean regexEndsNoSmallLetter;
    private boolean regexStartsNoUpperLetter;
    private boolean regexEndsNosUpperLetter;
    private boolean regexEndsNoDigit;
    private boolean regexStartsNoDigit;
    private boolean regexStartsNoSymbol;
    private boolean regexEndsNoSymbol;
    private boolean regexOnlyOneCapital;
    private boolean regexOnlyOneSymbol;
    private boolean regexAtLeastTwoSymbols;
    private boolean regexOnlyOneDigit;
    private boolean regexAtLeastTwoDigits;
    private int maxAttempts = DEFAULT_MAX_ATTEMPTS;

    public PasswordGeneratorImpl() {
        try {
            this.passwordFlags |= 2;
            log.debug((Object)Messages.getString("PwGenerator.debug_UPPERCASE_ON"));
            this.passwordFlags |= 1;
            log.debug((Object)Messages.getString("PwGenerator.debug_DIGITS_ON"));
            this.randomFactory = RandomFactory.getInstance();
            this.random = this.randomFactory.getSecureRandom();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            this.random = this.randomFactory.getRandom();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            this.random = this.randomFactory.getRandom();
        }
    }

    public String generateClearPassword() {
        List<String> pwds = this.process(1);
        return pwds.get(0);
    }

    public String generateClearPassword(SSOUser user, Set<ChallengeResponseCredential> challenges) {
        log.debug((Object)"User and challenges ignored!");
        List<String> pwds = this.process(1);
        return pwds.get(0);
    }

    public String generatePassword(int passwordLength, int passwordFlags) {
        if (passwordLength <= 2) {
            passwordFlags &= 0xFFFFFFFD;
            log.warn((Object)Messages.getString("PwGenerator.WARN_PL_UPERCASE_OFF"));
        }
        if (passwordLength <= 2) {
            passwordFlags &= 0xFFFFFFFB;
            log.warn((Object)Messages.getString("PwGenerator.WARN_PL_SYMBOLS_OFF"));
        }
        if (passwordLength <= 1) {
            passwordFlags &= 0xFFFFFFFE;
            log.warn((Object)Messages.getString("PwGenerator.WARN_PL_DIGITS_OFF"));
        }
        String password = null;
        for (int i = 0; i < this.getMaxAttempts(); ++i) {
            String element;
            IPasswordFilter filter;
            password = this.phonemes(passwordLength, passwordFlags);
            Set<String> filterIDs = this.filters.keySet();
            Iterator<String> iter = filterIDs.iterator();
            while (iter.hasNext() && (password = (filter = this.filters.get(element = iter.next())).filter(passwordFlags, password)) != null) {
            }
            if (password != null) break;
            log.debug((Object)(Messages.getString("PwGenerator.debug_ATTEMPT") + i + Messages.getString("PwGenerator.debug_ATTEMPT_GENERATE") + passwordFlags));
        }
        return password;
    }

    public List<String> process(int numberOfPasswords) {
        log.debug((Object)Messages.getString("PwGenerator.PASSWORD_GENERATOR"));
        ArrayList<String> passwords = new ArrayList<String>();
        if (this.isUseSimpleRandom()) {
            this.random = this.randomFactory.getRandom();
            log.debug((Object)Messages.getString("PwGenerator.NORMAL_RANDOM"));
        }
        try {
            this.random = this.randomFactory.getSecureRandom(this.getSecureRandomAlgorithm(), this.getSecureRandomProvider());
            log.debug((Object)(Messages.getString("PwGenerator.SEC_ALG") + this.getSecureRandomAlgorithm() + Messages.getString("PwGenerator.PROV") + this.getSecureRandomProvider() + Messages.getString("PwGenerator.DOR")));
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)(Messages.getString("PwGenerator.ERROR") + e.getMessage() + Messages.getString("PwGenerator.NEW_LINE")));
            log.debug((Object)Messages.getString("PwGenerator.DEFAUL_RANDOM"));
        }
        catch (NoSuchProviderException e) {
            log.error((Object)(Messages.getString("PwGenerator.ERROR") + e.getMessage() + Messages.getString("PwGenerator.NEW_LINE")));
            log.error((Object)Messages.getString("PwGenerator.DEFAUL_RANDOM"));
        }
        if (this.isGenerateNumerals()) {
            this.passwordFlags |= 1;
            log.debug((Object)Messages.getString("PwGenerator.DIGITS_ON"));
        } else {
            this.passwordFlags &= 0xFFFFFFFE;
            log.debug((Object)Messages.getString("PwGenerator.DIGITS_OFF"));
        }
        if (this.isGenerateCapitalLetters()) {
            this.passwordFlags |= 2;
            log.debug((Object)Messages.getString("PwGenerator.UPPERCASE_ON"));
        } else {
            this.passwordFlags &= 0xFFFFFFFD;
            log.debug((Object)Messages.getString("PwGenerator.UPPERCASE_OFF"));
        }
        if (this.isIncludeAmbigousChars()) {
            this.passwordFlags |= 8;
            log.debug((Object)Messages.getString("PwGenerator.AMBIGOUS_ON"));
        } else {
            this.passwordFlags &= 0xFFFFFFF7;
            log.debug((Object)Messages.getString("PwGenerator.AMBIGOUS_OFF"));
        }
        if (this.isIncludeSpecialSymbols()) {
            this.passwordFlags |= 4;
            log.debug((Object)Messages.getString("PwGenerator.SYMBOLS_ON"));
        } else {
            this.passwordFlags &= 0xFFFFFFFB;
            log.debug((Object)Messages.getString("PwGenerator.SYMBOLS_OFF"));
        }
        if (this.isRegexStartsNoSmallLetter()) {
            this.passwordFlags |= 0x10;
        }
        if (this.isRegexEndsNoSmallLetter()) {
            this.passwordFlags |= 0x10;
        }
        if (this.isRegexStartsNoUpperLetter()) {
            this.passwordFlags |= 0x40;
        }
        if (this.isRegexEndsNosUpperLetter()) {
            this.passwordFlags |= 0x80;
        }
        if (this.isRegexEndsNoDigit()) {
            this.passwordFlags |= 0x100;
        }
        if (this.isRegexStartsNoDigit()) {
            this.passwordFlags |= 0x200;
        }
        if (this.isRegexStartsNoSymbol()) {
            this.passwordFlags |= 0x400;
        }
        if (this.isRegexEndsNoSymbol()) {
            this.passwordFlags |= 0x800;
        }
        if (this.isRegexOnlyOneCapital()) {
            this.passwordFlags |= 0x1000;
        }
        if (this.isRegexOnlyOneSymbol()) {
            this.passwordFlags |= 0x2000;
        }
        if (this.isRegexAtLeastTwoSymbols()) {
            this.passwordFlags |= 0x4000;
        }
        if (this.isRegexOnlyOneDigit()) {
            this.passwordFlags |= 0x8000;
        }
        if (this.isRegexAtLeastTwoDigits()) {
            this.passwordFlags |= 0x10000;
        }
        log.debug((Object)Messages.getString("PwGenerator.GENRIC_FLAGS"));
        int res = this.passwordFlags & 1;
        log.debug((Object)(Messages.getString("PwGenerator.DIGITS") + (res != 0)));
        res = this.passwordFlags & 8;
        log.debug((Object)(Messages.getString("PwGenerator.AMBIGOUS") + (res != 0)));
        res = this.passwordFlags & 4;
        log.debug((Object)(Messages.getString("PwGenerator.SYMBOLS") + (res != 0)));
        res = this.passwordFlags & 2;
        log.debug((Object)(Messages.getString("PwGenerator.UPPERS") + (res != 0)));
        log.debug((Object)Messages.getString("PwGenerator.SEPARATOR"));
        log.debug((Object)(Messages.getString("PwGenerator.GENERATING") + numberOfPasswords + Messages.getString("PwGenerator.PW_LENGTH") + this.passwordLength));
        log.debug((Object)Messages.getString("PwGenerator.PW"));
        for (int i = 0; i < numberOfPasswords; ++i) {
            String password = this.generatePassword(this.passwordLength, this.passwordFlags);
            if (password == null) continue;
            passwords.add(password);
        }
        return passwords;
    }

    public IPasswordFilter addFilter(IPasswordFilter filter) {
        return this.filters.put(filter.getId(), filter);
    }

    public IPasswordFilter removeFilter(IPasswordFilter filter) {
        return this.filters.remove(filter.getId());
    }

    public IPasswordFilter removeFilter(String id) {
        return this.filters.remove(id);
    }

    public Collection<IPasswordFilter> getFilters() {
        return this.filters.values();
    }

    public void setFilters(Collection<IPasswordFilter> filters) {
        for (IPasswordFilter filter : filters) {
            this.filters.put(filter.getId(), filter);
        }
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public boolean isUseSimpleRandom() {
        return this.useSimpleRandom;
    }

    public void setUseSimpleRandom(boolean useSimpleRandom) {
        this.useSimpleRandom = useSimpleRandom;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    public boolean isGenerateNumerals() {
        return this.generateNumerals;
    }

    public void setGenerateNumerals(boolean generateNumerals) {
        this.generateNumerals = generateNumerals;
    }

    public boolean isGenerateCapitalLetters() {
        return this.generateCapitalLetters;
    }

    public void setGenerateCapitalLetters(boolean generateCapitalLetters) {
        this.generateCapitalLetters = generateCapitalLetters;
    }

    public boolean isIncludeAmbigousChars() {
        return this.includeAmbigousChars;
    }

    public void setIncludeAmbigousChars(boolean includeAmbigousChars) {
        this.includeAmbigousChars = includeAmbigousChars;
    }

    public boolean isIncludeSpecialSymbols() {
        return this.includeSpecialSymbols;
    }

    public void setIncludeSpecialSymbols(boolean includeSpecialSymbols) {
        this.includeSpecialSymbols = includeSpecialSymbols;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean isRegexStartsNoSmallLetter() {
        return this.regexStartsNoSmallLetter;
    }

    public void setRegexStartsNoSmallLetter(boolean regexStartsNoSmallLetter) {
        this.regexStartsNoSmallLetter = regexStartsNoSmallLetter;
    }

    public boolean isRegexEndsNoSmallLetter() {
        return this.regexEndsNoSmallLetter;
    }

    public void setRegexEndsNoSmallLetter(boolean regexEndsNoSmallLetter) {
        this.regexEndsNoSmallLetter = regexEndsNoSmallLetter;
    }

    public boolean isRegexStartsNoUpperLetter() {
        return this.regexStartsNoUpperLetter;
    }

    public void setRegexStartsNoUpperLetter(boolean regexStartsNoUpperLetter) {
        this.regexStartsNoUpperLetter = regexStartsNoUpperLetter;
    }

    public boolean isRegexEndsNosUpperLetter() {
        return this.regexEndsNosUpperLetter;
    }

    public void setRegexEndsNosUpperLetter(boolean regexEndsNosUpperLetter) {
        this.regexEndsNosUpperLetter = regexEndsNosUpperLetter;
    }

    public boolean isRegexEndsNoDigit() {
        return this.regexEndsNoDigit;
    }

    public void setRegexEndsNoDigit(boolean regexEndsNoDigit) {
        this.regexEndsNoDigit = regexEndsNoDigit;
    }

    public boolean isRegexStartsNoDigit() {
        return this.regexStartsNoDigit;
    }

    public void setRegexStartsNoDigit(boolean regexStartsNoDigit) {
        this.regexStartsNoDigit = regexStartsNoDigit;
    }

    public boolean isRegexStartsNoSymbol() {
        return this.regexStartsNoSymbol;
    }

    public void setRegexStartsNoSymbol(boolean regexStartsNoSymbol) {
        this.regexStartsNoSymbol = regexStartsNoSymbol;
    }

    public boolean isRegexEndsNoSymbol() {
        return this.regexEndsNoSymbol;
    }

    public void setRegexEndsNoSymbol(boolean regexEndsNoSymbol) {
        this.regexEndsNoSymbol = regexEndsNoSymbol;
    }

    public boolean isRegexOnlyOneCapital() {
        return this.regexOnlyOneCapital;
    }

    public void setRegexOnlyOneCapital(boolean regexOnlyOneCapital) {
        this.regexOnlyOneCapital = regexOnlyOneCapital;
    }

    public boolean isRegexOnlyOneSymbol() {
        return this.regexOnlyOneSymbol;
    }

    public void setRegexOnlyOneSymbol(boolean regexOnlyOneSymbol) {
        this.regexOnlyOneSymbol = regexOnlyOneSymbol;
    }

    public boolean isRegexAtLeastTwoSymbols() {
        return this.regexAtLeastTwoSymbols;
    }

    public void setRegexAtLeastTwoSymbols(boolean regexAtLeastTwoSymbols) {
        this.regexAtLeastTwoSymbols = regexAtLeastTwoSymbols;
    }

    public boolean isRegexOnlyOneDigit() {
        return this.regexOnlyOneDigit;
    }

    public void setRegexOnlyOneDigit(boolean regexOnlyOneDigit) {
        this.regexOnlyOneDigit = regexOnlyOneDigit;
    }

    public boolean isRegexAtLeastTwoDigits() {
        return this.regexAtLeastTwoDigits;
    }

    public void setRegexAtLeastTwoDigits(boolean regexAtLeastTwoDigits) {
        this.regexAtLeastTwoDigits = regexAtLeastTwoDigits;
    }

    private String phonemes(int size, int pw_flags) {
        int feature_flags;
        StringBuffer buf = new StringBuffer();
        block0: do {
            buf.delete(0, buf.length());
            feature_flags = pw_flags;
            int c = 0;
            int prev = 0;
            int should_be = 0;
            boolean first = true;
            int n = should_be = this.random.nextBoolean() ? 2 : 1;
            while (c < size) {
                char ch;
                int i = this.random.nextInt(PW_ELEMENTS.length);
                String str = PW_ELEMENTS[i].getValue();
                int len = str.length();
                int flags = PW_ELEMENTS[i].getType();
                if ((flags & should_be) == 0 || first && (flags & 8) != 0 || (prev & 2) != 0 && (flags & 2) != 0 && (flags & 4) != 0 || len > size - c) continue;
                buf.append(str);
                if ((pw_flags & 2) != 0 && (first || (flags & 1) != 0) && this.random.nextInt(10) < 2) {
                    int lastChar = buf.length() - 1;
                    buf.setCharAt(lastChar, Character.toUpperCase(buf.charAt(lastChar)));
                    feature_flags &= 0xFFFFFFFD;
                }
                c += len;
                if ((pw_flags & 8) != 0) {
                    int k = -1;
                    for (int j = 0; j < "B8G6I1l0OQDS5Z2".length() && (k = buf.indexOf(String.valueOf("B8G6I1l0OQDS5Z2".charAt(j)))) == -1; ++j) {
                    }
                    if (k != -1) {
                        buf.delete(k, buf.length());
                        c = buf.length();
                    }
                }
                if (c >= size) continue block0;
                if ((pw_flags & 1) != 0 && !first && this.random.nextInt(10) < 3) {
                    do {
                        ch = new Integer(this.random.nextInt(10)).toString().charAt(0);
                    } while ((pw_flags & 8) != 0 && "B8G6I1l0OQDS5Z2".indexOf(ch) != -1);
                    ++c;
                    buf = buf.append(ch);
                    feature_flags &= 0xFFFFFFFE;
                    first = true;
                    prev = 0;
                    should_be = this.random.nextBoolean() ? 2 : 1;
                    continue;
                }
                should_be = should_be == 1 ? 2 : ((prev & 2) != 0 || (flags & 4) != 0 || this.random.nextInt(10) > 3 ? 1 : 2);
                prev = flags;
                first = false;
                if ((pw_flags & 4) == 0 || first || this.random.nextInt(10) >= 2) continue;
                do {
                    ch = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".charAt(this.random.nextInt("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".length()));
                } while ((pw_flags & 8) != 0 && "B8G6I1l0OQDS5Z2".indexOf(ch) != -1);
                ++c;
                buf = buf.append(ch);
                feature_flags &= 0xFFFFFFFB;
            }
        } while ((feature_flags & 7) != 0);
        return buf.toString();
    }
}

