/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password.generator;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.selfservices.password.generator.IRandomFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomFactory
implements IRandomFactory {
    private static RandomFactory instance;
    private static final Log logger;

    public static RandomFactory getInstance() {
        if (instance == null) {
            instance = new RandomFactory();
        }
        return instance;
    }

    private RandomFactory() {
    }

    private SecureRandom initSecureRandom(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        logger.debug((Object)("Initializing random with: " + algorithm + " : " + provider));
        if (provider == null) {
            provider = "SUN";
        }
        SecureRandom sr = SecureRandom.getInstance(algorithm, provider);
        byte[] bytes = new byte[128];
        sr.nextBytes(bytes);
        int seedByteCount = 10;
        byte[] seed = sr.generateSeed(seedByteCount);
        sr = SecureRandom.getInstance(algorithm, provider);
        sr.setSeed(seed);
        SecureRandom sr2 = SecureRandom.getInstance(algorithm, provider);
        sr2.setSeed(seed);
        return sr2;
    }

    @Override
    public Set<String> getAlgorithms() {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                String value = (String)providers[i].get(string);
                result.add(value);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getServiceProviders() {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                void var6_6;
                String string2 = string.split(" ")[0];
                if (string2.startsWith("Alg.Alias.")) {
                    String string3 = string2.substring(10);
                }
                int ix = var6_6.indexOf(46);
                result.add(var6_6.substring(0, ix));
            }
        }
        return result;
    }

    @Override
    public Set<String> getServiceProviderFor(String type) {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                String string2 = string.split(" ")[0];
                if (string2.startsWith(type + ".")) {
                    result.add(string2.substring(type.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + type + ".")) continue;
                result.add(string2.substring(type.length() + 11));
            }
        }
        return result;
    }

    @Override
    public Provider[] getProviders() {
        return Security.getProviders();
    }

    @Override
    public Random getRandom() {
        return new Random(System.currentTimeMillis());
    }

    @Override
    public Random getRandom(long seed) {
        return new Random(seed);
    }

    @Override
    public Random getSecureRandom() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.initSecureRandom("SHA1PRNG", null);
    }

    @Override
    public Random getSecureRandom(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.initSecureRandom(algorithm, null);
    }

    @Override
    public Random getSecureRandom(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.initSecureRandom(algorithm, provider);
    }

    static {
        logger = LogFactory.getLog(RandomFactory.class);
    }
}

