/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb4.agent;

import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.naming.Util;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.util.CachePolicy;
import org.jboss.web.tomcat.security.JBossSecurityMgrRealm;
import org.jboss.web.tomcat.security.SecurityAssociationValve;
import org.josso.gateway.identity.SSOUser;
import org.josso.jb4.agent.JBossSecurityAssociationActions;
import org.josso.tc55.agent.jaas.CatalinaSSOUser;

public class JBossCatalinaRealm
extends JBossSecurityMgrRealm {
    private static final Log logger = LogFactory.getLog(JBossCatalinaRealm.class);
    private static final String JOSSO_SECURITY_DOMAIN = "java:/jaas/josso";
    private static final String DEFAULT_CACHE_POLICY_PATH = "java:/timedCacheFactory";
    private static String cacheJndiName = "java:/timedCacheFactory";

    protected boolean isSSODomain(String domain) {
        boolean isSSODomain = "josso".equals(domain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" JBoss Security Domain [" + domain + "] is" + (isSSODomain ? "" : " not") + " under SSO Control"));
        }
        return isSSODomain;
    }

    public Principal authenticate(String username, String credentials) {
        logger.debug((Object)("Begin authenticate, username=" + username));
        Object principal = null;
        SSOUser ssoUser = null;
        Principal caller = (Principal)SecurityAssociationValve.userPrincipal.get();
        if (caller == null && username == null && credentials == null) {
            return null;
        }
        try {
            Subject subject;
            Context securityCtx = null;
            securityCtx = this.prepareENC();
            if (securityCtx == null) {
                logger.error((Object)"No security context for authenticate(String, String)");
                return null;
            }
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            if (!this.isSSODomain(securityMgr.getSecurityDomain())) {
                return super.authenticate(username, credentials);
            }
            principal = new SimplePrincipal(username);
            char[] passwordChars = null;
            if (credentials != null) {
                passwordChars = credentials.toCharArray();
            }
            if (securityMgr.isValid((Principal)principal, (Object)credentials, subject = new Subject())) {
                logger.debug((Object)("User: " + username + " is authenticated"));
                logger.debug((Object)("Authenticated Subject: " + subject));
                Set<SSOUser> principals = subject.getPrincipals(SSOUser.class);
                Iterator<SSOUser> i = principals.iterator();
                if (i.hasNext()) {
                    ssoUser = i.next();
                }
                JBossSecurityAssociationActions.setPrincipalInfo((Principal)ssoUser, passwordChars, subject);
                RealmMapping rm = (RealmMapping)securityCtx.lookup("realmMapping");
                SSOUser oldPrincipal = ssoUser;
                principal = rm.getPrincipal((Principal)oldPrincipal);
                logger.debug((Object)("Mapped from input principal: " + oldPrincipal + " to: " + principal));
                principal = this.getCachingPrincpal(rm, (Principal)oldPrincipal, (Principal)principal, credentials, subject);
            } else {
                principal = null;
                logger.debug((Object)("User: " + username + " is NOT authenticated"));
            }
        }
        catch (NamingException e) {
            principal = null;
            logger.error((Object)"Error during authenticate", (Throwable)e);
        }
        logger.debug((Object)("End authenticate, principal=" + ssoUser));
        return ssoUser;
    }

    public boolean hasRole(Principal principal, String role) {
        boolean hasRole = false;
        try {
            Context securityCtx = null;
            securityCtx = this.prepareENC();
            if (securityCtx == null) {
                logger.error((Object)"No security context for authenticate(String, String)");
                return false;
            }
            logger.debug((Object)("hasRole(" + principal + "," + role + ")"));
            try {
                SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
                if (!this.isSSODomain(securityMgr.getSecurityDomain())) {
                    return super.hasRole(principal, role);
                }
                Subject activeSubject = securityMgr.getActiveSubject();
                logger.debug((Object)("Authenticated Subject: " + activeSubject));
                CatalinaSSOUser ssoUser = CatalinaSSOUser.newInstance((Realm)this, (Subject)activeSubject);
                hasRole = super.hasRole((Principal)ssoUser, role);
            }
            catch (NullPointerException npe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)npe);
                }
                hasRole = super.hasRole(principal, role);
            }
        }
        catch (NamingException e) {
            principal = null;
            logger.error((Object)"Error during authenticate", (Throwable)e);
        }
        return hasRole;
    }

    public Principal authenticate(X509Certificate[] certs) {
        logger.debug((Object)"authenticate(X509Certificate[]), Begin");
        try {
            this.prepareENC();
            return super.authenticate(certs);
        }
        catch (NamingException ne) {
            logger.error((Object)"Cannot create ENC Context");
            logger.debug((Object)"authenticate(), Emd");
            return null;
        }
    }

    protected Context prepareENC() throws NamingException {
        Context envCtx;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InitialContext iniCtx = new InitialContext();
        boolean securityContextExists = false;
        boolean isJaasSecurityManager = false;
        try {
            envCtx = (Context)iniCtx.lookup("java:comp/env");
            Context securityCtx = (Context)envCtx.lookup("security");
            securityContextExists = true;
            AuthenticationManager securityMgr = (AuthenticationManager)securityCtx.lookup("securityMgr");
            if (!(securityMgr instanceof JaasSecurityManager)) {
                Util.unbind((Context)envCtx, (String)"security");
            } else {
                isJaasSecurityManager = true;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        envCtx = null;
        if (!securityContextExists) {
            Thread currentThread = Thread.currentThread();
            logger.debug((Object)("Creating ENC using ClassLoader: " + loader));
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                logger.debug((Object)(".." + parent));
            }
            envCtx = (Context)iniCtx.lookup("java:comp");
            envCtx = envCtx.createSubcontext("env");
        } else {
            envCtx = (Context)iniCtx.lookup("java:comp/env");
        }
        if (!isJaasSecurityManager) {
            logger.debug((Object)"Linking security/securityMgr to JNDI name: java:/jaas/josso");
            Util.bind((Context)envCtx, (String)"security/securityMgr", (Object)new LinkRef(JOSSO_SECURITY_DOMAIN));
            Util.bind((Context)envCtx, (String)"security/realmMapping", (Object)new LinkRef(JOSSO_SECURITY_DOMAIN));
            Util.bind((Context)envCtx, (String)"security/security-domain", (Object)new LinkRef(JOSSO_SECURITY_DOMAIN));
            Util.bind((Context)envCtx, (String)"security/subject", (Object)new LinkRef("java:/jaas/josso/subject"));
        }
        logger.debug((Object)"JBossCatalinaRealm.prepareENC, End");
        return (Context)iniCtx.lookup("java:comp/env/security");
    }

    private static CachePolicy lookupCachePolicy(String securityDomain) {
        CachePolicy authCache = null;
        String domainCachePath = cacheJndiName + '/' + securityDomain;
        try {
            InitialContext iniCtx = new InitialContext();
            authCache = (CachePolicy)iniCtx.lookup(domainCachePath);
        }
        catch (Exception e) {
            try {
                InitialContext iniCtx = new InitialContext();
                authCache = (CachePolicy)iniCtx.lookup(cacheJndiName);
            }
            catch (Exception e2) {
                logger.warn((Object)("Failed to locate auth CachePolicy at: " + cacheJndiName + " for securityDomain=" + securityDomain));
            }
        }
        return authCache;
    }

    private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy) {
        try {
            Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
            Method m = securityMgr.getClass().getMethod("setCachePolicy", setCachePolicyTypes);
            Object[] setCachePolicyArgs = new Object[]{cachePolicy};
            m.invoke((Object)securityMgr, setCachePolicyArgs);
            logger.debug((Object)("setCachePolicy, c=" + setCachePolicyArgs[0]));
        }
        catch (Exception e2) {
            logger.debug((Object)"setCachePolicy failed", (Throwable)e2);
        }
    }
}

