/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb5.agent;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.jaspi.agent.SSOGatewayLoginModule;

public class JBossSSOGatewayLoginModule
extends SSOGatewayLoginModule {
    private static final Log logger = LogFactory.getLog(JBossSSOGatewayLoginModule.class);
    protected SSOUser _unauthenticatedIdentity;
    private Subject _savedSubject;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._savedSubject = subject;
        super.initialize(subject, callbackHandler, sharedState, options);
        String name = (String)options.get("unauthenticatedIdentity");
        if (name != null) {
            try {
                this._unauthenticatedIdentity = this.createIdentity(name);
                logger.debug((Object)("Saw unauthenticatedIdentity=" + name));
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to create custom unauthenticatedIdentity", (Throwable)e);
            }
        }
    }

    public boolean login() throws LoginException {
        if (!super.login()) {
            if (this._unauthenticatedIdentity != null) {
                logger.debug((Object)("Authenticated as unauthenticatedIdentity : " + this._unauthenticatedIdentity));
                this._ssoUserPrincipal = this._unauthenticatedIdentity;
                this._succeeded = true;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        boolean rc = false;
        rc = super.commit();
        Set<SSORole> ssoRolePrincipals = this._savedSubject.getPrincipals(SSORole.class);
        BaseRoleImpl targetGrp = new BaseRoleImpl("Roles");
        for (Principal principal : ssoRolePrincipals) {
            targetGrp.addMember(principal);
        }
        this._savedSubject.getPrincipals().add((Principal)targetGrp);
        Set<SSOUser> set = this._savedSubject.getPrincipals(SSOUser.class);
        BaseRoleImpl callerPrincipal = new BaseRoleImpl("CallerPrincipal");
        Iterator<SSOUser> j = set.iterator();
        if (j.hasNext()) {
            Principal user = (Principal)j.next();
            callerPrincipal.addMember(user);
        }
        this._savedSubject.getPrincipals().add((Principal)callerPrincipal);
        return rc;
    }

    protected SSORole[] getRoleSets() throws LoginException {
        if (this._ssoUserPrincipal == this._unauthenticatedIdentity) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using unauthenticatedIdentity " + this._ssoUserPrincipal + ", returning no roles."));
            }
            return new SSORole[0];
        }
        return super.getRoleSets();
    }

    protected SSOUser createIdentity(String username) {
        return new BaseUserImpl(username);
    }
}

