/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb5.agent;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.web.tomcat.security.jaspi.TomcatJASPIAuthenticator;
import org.josso.agent.Lookup;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.jaspi.agent.JASPICallbackHandler;
import org.josso.jb5.agent.JBossSecurityAssociationActions;

public class JOSSOJASPIAuthenticator
extends TomcatJASPIAuthenticator {
    private static final Log log = LogFactory.getLog(JOSSOJASPIAuthenticator.class);
    private String messageLayer = "HttpServlet";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Security checking request " + request.getMethod() + " " + request.getRequestURI()));
        }
        LoginConfig config = this.context.getLoginConfig();
        Principal principal = request.getUserPrincipal();
        if (principal == null && (session = request.getSessionInternal(false)) != null) {
            if (!this.jossoCookieExists(request)) {
                session.setPrincipal(null);
            }
            if ((principal = session.getPrincipal()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal()));
                }
                request.setAuthType(session.getAuthType());
                request.setUserPrincipal(principal);
            }
        }
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(request, this.context);
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling hasUserDataPermission()");
        }
        if (!realm.hasUserDataPermission(request, response, constraints)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed hasUserDataPermission() test");
            }
            return;
        }
        if (!this.authenticate(request, response, config)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed authenticate() test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling accessControl()");
        }
        if (!realm.hasResourcePermission(request, response, constraints, this.context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed accessControl() test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    protected boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        boolean result = false;
        String authMethod = config.getAuthMethod();
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
        }
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(request, this.context);
        if (!this.jossoCookieExists(request) && principal == null && constraints != null && constraints.length > 0) {
            boolean authRequired = true;
            for (int i = 0; i < constraints.length && authRequired; ++i) {
                String[] roles;
                if (!constraints[i].getAuthConstraint()) {
                    authRequired = false;
                    continue;
                }
                if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
                authRequired = false;
            }
            if (authRequired) {
                this.forwardToLoginPage(request, response, config);
                return false;
            }
        }
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)request);
        messageInfo.setResponseMessage((Object)response);
        messageInfo.getMap().put("CACHE", this.cache);
        JASPICallbackHandler cbh = new JASPICallbackHandler();
        Subject subject = new Subject();
        ServerAuthenticationManager sam = this.getServerAuthenticationManager();
        if (sam != null) {
            result = sam.isValid((MessageInfo)messageInfo, subject, this.messageLayer, (CallbackHandler)cbh);
        }
        if (result) {
            PasswordValidationCallback pvc = cbh.getPasswordValidationCallback();
            CallerPrincipalCallback cpcb = cbh.getCallerPrincipalCallback();
            if (pvc != null && cpcb != null) {
                this.register(request, response, cpcb.getPrincipal(), authMethod, pvc.getUsername(), new String(pvc.getPassword()));
                JBossSecurityAssociationActions.setPrincipalInfo(cpcb.getPrincipal(), new String(pvc.getPassword()), subject);
            }
        }
        return result;
    }

    protected void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        if (log.isTraceEnabled()) {
            String name = principal == null ? "none" : principal.getName();
            log.trace((Object)("Authenticated '" + name + "' with type '" + authType + "'"));
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null && this.cache) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
        }
    }

    protected void forwardToLoginPage(Request request, Response response, LoginConfig config) {
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getLoginPage());
        try {
            Lookup lookup = Lookup.getInstance();
            lookup.init("josso-agent-config.xml");
            HttpSSOAgent agent = (HttpSSOAgent)lookup.lookupSSOAgent();
            agent.setAttribute(request.getRequest(), response.getResponse(), "JOSSO_SAVED_REQUEST", this.getRequestURI(request));
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            response.finishResponse();
        }
        catch (Throwable t) {
            log.warn((Object)"Unexpected error forwarding to login page", t);
        }
    }

    protected String getRequestURI(Request request) {
        StringBuffer requestURI = new StringBuffer(request.getRequestURI());
        if (request.getQueryString() != null) {
            requestURI.append('?');
            requestURI.append(request.getQueryString());
        }
        return requestURI.toString();
    }

    protected boolean jossoCookieExists(Request request) {
        boolean jossoCookieExists = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"JOSSO_SESSIONID".equals(cookie.getName())) continue;
                if (cookie.getValue() == null || cookie.getValue().equals("-")) break;
                jossoCookieExists = true;
                break;
            }
        }
        return jossoCookieExists;
    }
}

