/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb7.agent;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.as.web.security.JBossWebRealm;
import org.jboss.as.web.security.jaspi.WebJASPIAuthenticator;
import org.jboss.logging.Logger;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.josso.agent.LocalSession;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.jaspi.agent.JASPICallbackHandler;
import org.josso.jaspi.agent.JASPISSOAgentRequest;

public class JOSSOJASPIAuthenticator
extends WebJASPIAuthenticator {
    public static final String KEY_SESSION_MAP = "org.josso.servlet.agent.sessionMap";
    private static Logger log = Logger.getLogger(JOSSOJASPIAuthenticator.class);
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));
    private static HttpSSOAgent _agent;

    public JOSSOJASPIAuthenticator() {
        try {
            if (_agent == null) {
                Lookup lookup = Lookup.getInstance();
                lookup.init("josso-agent-config.xml");
                _agent = (HttpSSOAgent)lookup.lookupSSOAgent();
                if (log.isDebugEnabled()) {
                    _agent.setDebug(1);
                }
                _agent.start();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error starting SSO Agent : " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("Error starting SSO Agent : " + e.getMessage(), e);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Realm realm;
        SecurityConstraint[] constraints;
        Session session;
        Principal principal;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Security checking request " + request.getMethod() + " " + request.getRequestURI()));
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = request.getUserPrincipal()) == null && (session = request.getSessionInternal(false)) != null) {
            if (!this.jossoCookieExists(request)) {
                session.setPrincipal(null);
            }
            if ((principal = session.getPrincipal()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal()));
                }
                request.setAuthType(session.getAuthType());
                request.setUserPrincipal(principal);
            }
        }
        String contextPath = this.context.getPath();
        String requestURI = request.getDecodedRequestURI();
        if ((requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") || this.isJossoReservedUri(contextPath, requestURI)) && !this.authenticate(request, (HttpServletResponse)response, config)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Failed authenticate() test ??" + requestURI));
            }
            return;
        }
        if (this.disableProxyCaching && !"POST".equalsIgnoreCase(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else {
                response.setHeader("Cache-Control", "private");
            }
            response.setHeader("Expires", DATE_ONE);
        }
        if ((constraints = (realm = this.context.getRealm()).findSecurityConstraints(request, this.context)) == null) {
            constraints = new SecurityConstraint[]{};
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling hasUserDataPermission()");
        }
        if (!realm.hasUserDataPermission(request, response, constraints)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed hasUserDataPermission() test");
            }
            return;
        }
        boolean authRequired = true;
        for (int i = 0; i < constraints.length && authRequired; ++i) {
            String[] roles;
            if (!constraints[i].getAuthConstraint()) {
                authRequired = false;
                continue;
            }
            if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
            authRequired = false;
        }
        if (authRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Calling authenticate()");
            }
            if (!this.authenticate(request, (HttpServletResponse)response, config)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Failed authenticate() test");
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling accessControl()");
        }
        if (!realm.hasResourcePermission(request, response, constraints, this.context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed accessControl() test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    protected boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        boolean result = false;
        String authMethod = config.getAuthMethod();
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            String requestURI;
            String contextPath;
            WebLogger.WEB_SECURITY_LOGGER.tracef("Already authenticated '%s'", (Object)principal.getName());
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            if (!_agent.isAgentReservedUri(contextPath = this.context.getPath(), requestURI = request.getDecodedRequestURI())) {
                return true;
            }
        }
        if (("BASIC".equalsIgnoreCase(authMethod) || "FORM".equalsIgnoreCase(authMethod)) && ssoId != null) {
            WebLogger.WEB_SECURITY_LOGGER.tracef("SSO Id %s set; attempting reauthentication", (Object)ssoId);
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(request, this.context);
        if (!this.jossoCookieExists(request) && principal == null && constraints != null && constraints.length > 0) {
            boolean authRequired = true;
            for (int i = 0; i < constraints.length && authRequired; ++i) {
                String[] roles;
                if (!constraints[i].getAuthConstraint()) {
                    authRequired = false;
                    continue;
                }
                if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
                authRequired = false;
            }
            if (authRequired) {
                this.forwardToLoginPage(request, request.getResponse(), config);
                return false;
            }
        }
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)request);
        messageInfo.setResponseMessage((Object)request.getResponse());
        messageInfo.getMap().put("CACHE", String.valueOf(this.cache));
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", "true");
        JASPICallbackHandler cbh = new JASPICallbackHandler();
        ServerAuthenticationManager sam = this.getServerAuthenticationManager();
        String appContext = request.getLocalName() + " " + request.getContextPath();
        Subject clientSubject = new Subject();
        if (sam != null) {
            result = sam.isValid((MessageInfo)messageInfo, clientSubject, "HttpServlet", appContext, (CallbackHandler)cbh);
        }
        if (result) {
            PasswordValidationCallback pvc = cbh.getPasswordValidationCallback();
            CallerPrincipalCallback cpc = cbh.getCallerPrincipalCallback();
            GroupPrincipalCallback gpc = cbh.getGroupPrincipalCallback();
            if (cpc == null) {
                return constraints == null;
            }
            Principal clientPrincipal = cpc.getPrincipal();
            if (clientPrincipal == null) {
                clientPrincipal = new SimplePrincipal(cpc.getName());
            }
            if (!(clientPrincipal instanceof JBossGenericPrincipal)) {
                clientPrincipal = this.buildJBossPrincipal(clientSubject, clientPrincipal, gpc);
            }
            String passwordString = pvc != null && pvc.getPassword() != null ? new String(pvc.getPassword()) : null;
            String passwordUsername = pvc != null && pvc.getUsername() != null ? pvc.getUsername() : null;
            this.register(request, response, clientPrincipal, authMethod, passwordUsername, passwordString);
            if (this.secureResponse) {
                sam.secureResponse((MessageInfo)messageInfo, new Subject(), "HttpServlet", appContext, (CallbackHandler)cbh);
            }
        }
        return result;
    }

    protected Principal buildJBossPrincipal(Subject subject, Principal principal, GroupPrincipalCallback gpc) {
        JBossWebRealm realm;
        Set descriptorRoles;
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal p : subject.getPrincipals()) {
            if (!(p instanceof Group) || !p.getName().equals("Roles")) continue;
            Enumeration members = ((Group)p).members();
            while (members.hasMoreElements()) {
                roles.add(((Principal)members.nextElement()).getName());
            }
        }
        if (gpc != null && gpc.getGroups() != null) {
            for (String group : gpc.getGroups()) {
                roles.add(group);
            }
        }
        if ((descriptorRoles = (Set)(realm = (JBossWebRealm)this.getContainer().getRealm()).getPrincipalVersusRolesMap().get(principal.getName())) != null) {
            roles.addAll(descriptorRoles);
        }
        return new JBossGenericPrincipal((Realm)realm, principal.getName(), null, roles, principal, null, null, null, subject);
    }

    protected void forwardToLoginPage(Request request, Response response, LoginConfig config) {
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getLoginPage());
        try {
            Lookup lookup = Lookup.getInstance();
            lookup.init("josso-agent-config.xml");
            HttpSSOAgent agent = (HttpSSOAgent)lookup.lookupSSOAgent();
            agent.setAttribute(request.getRequest(), response.getResponse(), "JOSSO_SAVED_REQUEST", this.getRequestURI(request));
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            response.finishResponse();
        }
        catch (Throwable t) {
            log.warn((Object)"Unexpected error forwarding to login page", t);
        }
    }

    protected String getRequestURI(Request request) {
        StringBuffer requestURI = new StringBuffer(request.getRequestURI());
        if (request.getQueryString() != null) {
            requestURI.append('?');
            requestURI.append(request.getQueryString());
        }
        return requestURI.toString();
    }

    protected boolean jossoCookieExists(Request request) {
        boolean jossoCookieExists = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"JOSSO_SESSIONID".equals(cookie.getName())) continue;
                if (cookie.getValue() == null || cookie.getValue().equals("-")) break;
                jossoCookieExists = true;
                break;
            }
        }
        return jossoCookieExists;
    }

    protected void saveLoginBackToURL(HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean overrideSavedResource) {
        String referer = request.getHeader("referer");
        if ((this.getSavedRequestURL(request) == null || overrideSavedResource) && referer != null && !referer.equals("")) {
            _agent.setAttribute(request, response, "JOSSO_SAVED_REQUEST", referer);
        }
    }

    private String getSavedRequestURL(HttpServletRequest hreq) {
        return _agent.getAttribute(hreq, "JOSSO_SAVED_REQUEST");
    }

    private String getSavedSplashResource(HttpServletRequest hreq) {
        return _agent.getAttribute(hreq, "josso_splash_resource");
    }

    protected SSOAgentRequest doMakeSSOAgentRequest(String requester, int action, String sessionId, LocalSession session, String assertionId, HttpServletRequest hreq, HttpServletResponse hres) {
        JASPISSOAgentRequest r = new JASPISSOAgentRequest(requester, action, sessionId, session, assertionId);
        r.setRequest(hreq);
        r.setResponse(hres);
        return r;
    }

    protected boolean isJossoReservedUri(String contextPath, String uri) {
        return _agent.isAgentReservedUri(contextPath, uri);
    }
}

