/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jbportal27.agent;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.josso.auth.BindableCredentialStore;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AuthenticationScheme;
import org.josso.auth.scheme.PasswordCredential;
import org.josso.auth.scheme.UsernameCredential;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.IdentityStore;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;
import org.josso.jbportal27.agent.JOSSOIdentityService;

public class JOSSOIdentityStore
implements IdentityStore,
BindableCredentialStore {
    private static final Log logger = LogFactory.getLog(JOSSOIdentityStore.class);
    private AuthenticationScheme authenticationScheme = null;
    private JOSSOIdentityService portalIdentityService = null;

    public JOSSOIdentityStore() {
        try {
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            this.portalIdentityService = (JOSSOIdentityService)MBeanProxy.get(JOSSOIdentityService.class, (ObjectName)new ObjectName("portal:service=Module,type=JOSSOIdentityService"), (MBeanServer)mbeanServer);
        }
        catch (Exception e) {
            this.authenticationScheme = null;
            this.portalIdentityService = null;
            logger.error((Object)this, (Throwable)e);
            throw new RuntimeException("JOSSOIdentityStore registration failed....");
        }
    }

    public BaseRole[] findRolesByUserKey(UserKey userKey) throws SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        String[] userRoles = this.portalIdentityService.getUserRoles(userKey.toString());
        BaseRole[] roles = new BaseRole[userRoles.length];
        for (int i = 0; i < userRoles.length; ++i) {
            roles[i] = new BaseRoleImpl(userRoles[i]);
        }
        return roles;
    }

    public BaseUser loadUser(UserKey userKey) throws NoSuchUserException, SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        BaseUserImpl user = new BaseUserImpl();
        user.setName(userKey.toString());
        user.addProperty("password", "");
        return user;
    }

    public boolean userExists(UserKey userKey) throws SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        return this.portalIdentityService.exists(userKey.toString());
    }

    public Credential[] loadCredentials(CredentialKey credentialKey) throws SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        BaseUser user = this.loadUser((UserKey)((SimpleUserKey)credentialKey));
        SSONameValuePair[] properties = user.getProperties();
        String password = properties[0].getValue();
        return new Credential[]{new UsernameCredential((Object)user.getName()), new PasswordCredential((Object)password)};
    }

    public Credential[] loadCredentials(CredentialKey credentialKey, CredentialProvider credentialProvider) throws SSOIdentityException {
        return this.loadCredentials(credentialKey);
    }

    public boolean bind(String username, String password) throws SSOAuthenticationException {
        return this.portalIdentityService.authenticate(username, password);
    }

    public void setAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        this.authenticationScheme = authenticationScheme;
    }

    public String loadUID(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        throw new UnsupportedOperationException("Not implemented for this agent!");
    }
}

