/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.ldap;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.BaseCredential;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.AbstractStore;
import org.josso.gateway.identity.service.store.ExtendedIdentityStore;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;
import org.josso.selfservices.ChallengeResponseCredential;

public class LDAPIdentityStore
extends AbstractStore
implements ExtendedIdentityStore {
    private static final Log logger = LogFactory.getLog(LDAPIdentityStore.class);
    private static final String USERPASSWORD_SCHEME_MD5 = "{md5}";
    private static final String USERPASSWORD_SCHEME_CRYPT = "{crypt}";
    private static final String USERPASSWORD_SCHEME_SHA = "{sha}";
    private String _initialContextFactory;
    private String _providerUrl;
    private String _securityAuthentication;
    private String _rolesCtxDN;
    private String _uidAttributeID;
    private String _roleAttributeID;
    private String _roleMatchingMode;
    private String _securityProtocol;
    private String _securityPrincipal;
    private String _securityCredential;
    private String _principalUidAttributeID;
    private String _usersCtxDN;
    private String _credentialQueryString;
    private String _userPropertiesQueryString;
    private String _ldapSearchScope;
    private String _updateableCredentialAttribute;

    public BaseUser loadUser(UserKey key) throws NoSuchUserException, SSOIdentityException {
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            String uid = this.selectUser(((SimpleUserKey)key).getId());
            BaseUserImpl bu = new BaseUserImpl();
            bu.setName(uid);
            ArrayList<SSONameValuePair> userProperties = new ArrayList<SSONameValuePair>();
            if (this.getUserPropertiesQueryString() != null) {
                HashMap userPropertiesResultSet = this.selectUserProperties(((SimpleUserKey)key).getId());
                for (String pName : userPropertiesResultSet.keySet()) {
                    String pValue = (String)userPropertiesResultSet.get(pName);
                    SSONameValuePair vp = new SSONameValuePair(pName, pValue);
                    userProperties.add(vp);
                }
            }
            String dn = this.selectUserDN(((SimpleUserKey)key).getId());
            userProperties.add(new SSONameValuePair("josso.user.dn", dn));
            SSONameValuePair[] props = userProperties.toArray(new SSONameValuePair[userProperties.size()]);
            bu.setProperties(props);
            return bu;
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining user", (Throwable)e);
            throw new SSOIdentityException("Error obtaining user : " + key);
        }
    }

    public BaseRole[] findRolesByUserKey(UserKey key) throws SSOIdentityException {
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            String[] roleNames = this.selectRolesByUsername(((SimpleUserKey)key).getId());
            ArrayList<BaseRoleImpl> roles = new ArrayList<BaseRoleImpl>();
            for (int i = 0; i < roleNames.length; ++i) {
                String roleName = roleNames[i];
                BaseRoleImpl role = new BaseRoleImpl();
                role.setName(roleName);
                roles.add(role);
            }
            return roles.toArray(new BaseRole[roles.size()]);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining roles", (Throwable)e);
            throw new SSOIdentityException("Error obtaining roles for user : " + key);
        }
    }

    public String loadUsernameByRelayCredential(ChallengeResponseCredential cred) throws SSOIdentityException {
        try {
            return this.selectUser(cred.getId(), cred.getResponse());
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining user with relay credential", (Throwable)e);
            throw new SSOIdentityException("Error obtaining user with relay credential: ID[" + cred.getId() + "] = RESPONSE[" + cred.getResponse() + "]");
        }
    }

    public void updateAccountPassword(UserKey key, Credential newPassword) throws SSOIdentityException {
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            BasicAttributes atts = new BasicAttributes();
            atts.put(this.getUpdateableCredentialAttribute(), ((BaseCredential)newPassword).getValue());
            this.replaceAttributes(this.selectUserDN(((SimpleUserKey)key).getId()), atts);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while updating password account", (Throwable)e);
            throw new SSOIdentityException("Error updating password account for user : " + key);
        }
    }

    public Credential[] loadCredentials(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        try {
            if (!(key instanceof CredentialKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            HashMap credentialResultSet = this.selectCredentials(((SimpleUserKey)key).getId());
            for (String cName : credentialResultSet.keySet()) {
                Object cValue = credentialResultSet.get(cName);
                Credential c = cp.newCredential(cName, cValue);
                credentials.add(c);
            }
            return credentials.toArray(new Credential[credentialResultSet.size()]);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining Credentials", (Throwable)e);
            throw new SSOIdentityException("Error obtaining credentials for user : " + key);
        }
    }

    protected String[] selectRolesByUsername(String username) throws NamingException {
        InitialLdapContext ctx;
        ArrayList<String> userRoles;
        block13: {
            userRoles = new ArrayList<String>();
            ctx = this.createLdapInitialContext();
            String rolesCtxDN = this.getRolesCtxDN();
            if (rolesCtxDN != null) {
                String roleAttrName;
                String uidAttributeID = this.getUidAttributeID();
                if (uidAttributeID == null) {
                    uidAttributeID = "uniquemember";
                }
                if ((roleAttrName = this.getRoleAttributeID()) == null) {
                    roleAttrName = "roles";
                }
                String userDN = "UID".equals(this.getRoleMatchingMode()) ? username : this.selectUserDN(username);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Searching Roles for user '" + userDN + "' in Uid attribute name '" + uidAttributeID + "'"));
                }
                try {
                    if (userDN.contains("\\")) {
                        logger.debug((Object)"Escaping '\\' character");
                        userDN = userDN.replace("\\", "\\\\\\");
                    }
                    NamingEnumeration<SearchResult> answer = ctx.search(rolesCtxDN, "(&(" + uidAttributeID + "=" + userDN + "))", this.getSearchControls());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Search Name:  " + rolesCtxDN));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Search Filter:  (&(" + uidAttributeID + "=" + userDN + "))"));
                    }
                    if (!answer.hasMore()) {
                        logger.info((Object)("No role where found for user " + username));
                    }
                    while (answer.hasMore()) {
                        SearchResult sr = answer.next();
                        Attributes attrs = sr.getAttributes();
                        Attribute roles = attrs.get(roleAttrName);
                        for (int r = 0; r < roles.size(); ++r) {
                            Object value = roles.get(r);
                            String roleName = null;
                            roleName = value.toString();
                            if (roleName == null) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Saving role '" + roleName + "' for user '" + username + "'"));
                            }
                            userRoles.add(roleName);
                        }
                    }
                }
                catch (NamingException e) {
                    if (!logger.isDebugEnabled()) break block13;
                    logger.debug((Object)"Failed to locate roles", (Throwable)e);
                }
            }
        }
        ctx.close();
        return userRoles.toArray(new String[userRoles.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectUserDN(String uid) throws NamingException {
        String dn = null;
        InitialLdapContext ctx = this.createLdapInitialContext();
        String principalUidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalUidAttrName + "=" + uid + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute uidAttr = attrs.get(principalUidAttrName);
                if (uidAttr == null) {
                    logger.warn((Object)("Invalid user uid attribute '" + principalUidAttrName + "'"));
                    continue;
                }
                String uidValue = uidAttr.get().toString();
                if (uidValue != null) {
                    dn = sr.getName() + "," + usersCtxDN;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user '" + principalUidAttrName + "=" + uidValue + "' for user '" + uid + "' DN=" + dn));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("User not found for user '" + uid + "'"));
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            ctx.close();
        }
        return dn;
    }

    protected String selectUser(String uid) throws NamingException {
        return this.selectUser(this.getPrincipalUidAttributeID(), uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectUser(String attrId, String attrValue) throws NamingException {
        String uidValue = null;
        InitialLdapContext ctx = this.createLdapInitialContext();
        BasicAttributes matchAttrs = new BasicAttributes(true);
        String uidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        matchAttrs.put(attrId, attrValue);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + attrId + "=" + attrValue + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute uidAttr = attrs.get(uidAttrName);
                if (uidAttr == null) {
                    logger.warn((Object)("Invalid user attrValue attribute '" + uidAttrName + "'"));
                    continue;
                }
                uidValue = uidAttr.get().toString();
                if (uidValue != null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user '" + uidAttrName + "=" + uidValue + "' for user '" + attrValue + "'"));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("User not found for user '" + attrValue + "'"));
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            ctx.close();
        }
        return uidValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap selectCredentials(String uid) throws NamingException {
        HashMap<String, Object> credentialResultSet = new HashMap<String, Object>();
        InitialLdapContext ctx = this.createLdapInitialContext();
        String principalUidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        String credentialQueryString = this.getCredentialQueryString();
        HashMap credentialQueryMap = this.parseQueryString(credentialQueryString);
        Iterator i = credentialQueryMap.keySet().iterator();
        ArrayList<String> credentialAttrList = new ArrayList<String>();
        while (i.hasNext()) {
            String o = (String)i.next();
            credentialAttrList.add(o);
        }
        String[] credentialAttr = credentialAttrList.toArray(new String[credentialAttrList.size()]);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalUidAttrName + "=" + uid + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                for (int j = 0; j < credentialAttr.length; ++j) {
                    Object credentialObject = attrs.get(credentialAttr[j]).get();
                    String credentialName = (String)credentialQueryMap.get(credentialAttr[j]);
                    String credentialValue = null;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found user credential '" + credentialName + "' of type '" + credentialObject.getClass().getName() + "" + (credentialObject.getClass().isArray() ? "[" + Array.getLength(credentialObject) + "]" : "") + "'"));
                    }
                    if (credentialObject.getClass().isArray()) {
                        try {
                            byte[] credentialData = (byte[])credentialObject;
                            ByteBuffer in = ByteBuffer.allocate(credentialData.length);
                            in.put(credentialData);
                            in.flip();
                            Charset charset = Charset.forName("UTF-8");
                            CharsetDecoder decoder = charset.newDecoder();
                            CharBuffer charBuffer = decoder.decode(in);
                            credentialValue = charBuffer.toString();
                        }
                        catch (CharacterCodingException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Can't convert credential value to String using UTF-8");
                            }
                        }
                    } else if (credentialObject instanceof String) {
                        credentialValue = (String)credentialObject;
                    }
                    if (credentialValue != null) {
                        credentialValue = this.getSchemeFreeValue(credentialValue);
                        credentialResultSet.put(credentialName, credentialValue);
                    } else {
                        credentialResultSet.put(credentialName, credentialObject);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user credential '" + credentialName + "' with value '" + (credentialValue != null ? credentialValue : credentialObject) + "'"));
                }
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            ctx.close();
        }
        return credentialResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap selectUserProperties(String uid) throws NamingException {
        HashMap<String, String> userPropertiesResultSet = new HashMap<String, String>();
        InitialLdapContext ctx = this.createLdapInitialContext();
        BasicAttributes matchAttrs = new BasicAttributes(true);
        String principalUidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        matchAttrs.put(principalUidAttrName, uid);
        String userPropertiesQueryString = this.getUserPropertiesQueryString();
        HashMap userPropertiesQueryMap = this.parseQueryString(userPropertiesQueryString);
        Iterator i = userPropertiesQueryMap.keySet().iterator();
        ArrayList<String> propertiesAttrList = new ArrayList<String>();
        while (i.hasNext()) {
            String o = (String)i.next();
            propertiesAttrList.add(o);
        }
        String[] propertiesAttr = propertiesAttrList.toArray(new String[propertiesAttrList.size()]);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalUidAttrName + "=" + uid + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                for (int j = 0; j < propertiesAttr.length; ++j) {
                    Attribute attribute = attrs.get(propertiesAttr[j]);
                    if (attribute == null) {
                        logger.warn((Object)("Invalid user property attribute '" + propertiesAttr[j] + "'"));
                        continue;
                    }
                    Object propertyObject = attrs.get(propertiesAttr[j]).get();
                    if (propertyObject == null) {
                        logger.warn((Object)("Found a 'null' value for user property '" + propertiesAttr[j] + "'"));
                        continue;
                    }
                    String propertyValue = propertyObject.toString();
                    String propertyName = (String)userPropertiesQueryMap.get(propertiesAttr[j]);
                    userPropertiesResultSet.put(propertyName, propertyValue);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user property '" + propertyName + "' with value '" + propertyValue + "'"));
                }
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            ctx.close();
        }
        return userPropertiesResultSet;
    }

    protected void replaceAttributes(String bane, Attributes atts) throws NamingException {
        InitialLdapContext ctx = this.createLdapInitialContext();
        ctx.modifyAttributes(bane, 2, atts);
    }

    protected InitialLdapContext createLdapInitialContext() throws NamingException {
        String securityCredential;
        String securityPrincipal = this.getSecurityPrincipal();
        if (securityPrincipal == null) {
            securityPrincipal = "";
        }
        if ((securityCredential = this.getSecurityCredential()) == null) {
            securityCredential = "";
        }
        return this.createLdapInitialContext(securityPrincipal, securityCredential);
    }

    protected InitialLdapContext createLdapInitialContext(String securityPrincipal, String securityCredential) throws NamingException {
        String authType;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.getInitialContextFactory());
        env.setProperty("java.naming.security.authentication", this.getSecurityAuthentication());
        env.setProperty("java.naming.provider.url", this.getProviderUrl());
        env.setProperty("java.naming.security.protocol", this.getSecurityProtocol() == null ? "" : this.getSecurityProtocol());
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = this.getProviderUrl();
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        env.setProperty("java.naming.security.principal", securityPrincipal);
        env.put("java.naming.security.credentials", securityCredential);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Logging into LDAP server, env=" + env));
        }
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Logged into LDAP server, " + ctx));
        }
        return ctx;
    }

    protected String getSchemeFreeValue(String attributeValue) {
        String targetValue = attributeValue;
        if (attributeValue.toLowerCase().startsWith(USERPASSWORD_SCHEME_CRYPT)) {
            targetValue = attributeValue.substring(USERPASSWORD_SCHEME_CRYPT.length());
        } else if (attributeValue.toLowerCase().startsWith(USERPASSWORD_SCHEME_MD5)) {
            targetValue = attributeValue.substring(USERPASSWORD_SCHEME_MD5.length());
        } else if (attributeValue.toLowerCase().startsWith(USERPASSWORD_SCHEME_SHA)) {
            targetValue = attributeValue.substring(USERPASSWORD_SCHEME_SHA.length());
        }
        return targetValue;
    }

    protected HashMap parseQueryString(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = pair.substring(0, pos);
            String val = pair.substring(pos + 1, pair.length());
            hm.put(key, val);
        }
        return hm;
    }

    protected SearchControls getSearchControls() {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(this._ldapSearchScope == null || this._ldapSearchScope.equalsIgnoreCase("ONELEVEL") ? 1 : 2);
        return sc;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this._initialContextFactory = initialContextFactory;
    }

    public String getInitialContextFactory() {
        return this._initialContextFactory;
    }

    public void setProviderUrl(String providerUrl) {
        this._providerUrl = providerUrl;
    }

    public String getProviderUrl() {
        return this._providerUrl;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this._securityAuthentication = securityAuthentication;
    }

    public String getSecurityAuthentication() {
        return this._securityAuthentication;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this._securityProtocol = securityProtocol;
    }

    public String getSecurityProtocol() {
        return this._securityProtocol;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this._securityPrincipal = securityPrincipal;
    }

    public String getSecurityPrincipal() {
        return this._securityPrincipal;
    }

    public void setSecurityCredential(String securityCredential) {
        this._securityCredential = securityCredential;
    }

    protected String getSecurityCredential() {
        return this._securityCredential;
    }

    public String getLdapSearchScope() {
        return this._ldapSearchScope;
    }

    public void setLdapSearchScope(String ldapSearchScope) {
        this._ldapSearchScope = ldapSearchScope;
    }

    public void setUsersCtxDN(String usersCtxDN) {
        this._usersCtxDN = usersCtxDN;
    }

    public String getUsersCtxDN() {
        return this._usersCtxDN;
    }

    public void setRolesCtxDN(String rolesCtxDN) {
        this._rolesCtxDN = rolesCtxDN;
    }

    public String getRolesCtxDN() {
        return this._rolesCtxDN;
    }

    public void setPrincipalUidAttributeID(String principalUidAttributeID) {
        this._principalUidAttributeID = principalUidAttributeID;
    }

    public String getPrincipalUidAttributeID() {
        return this._principalUidAttributeID;
    }

    public void setUidAttributeID(String uidAttributeID) {
        this._uidAttributeID = uidAttributeID;
    }

    public String getRoleMatchingMode() {
        return this._roleMatchingMode;
    }

    public void setRoleMatchingMode(String roleMatchingMode) {
        this._roleMatchingMode = roleMatchingMode;
    }

    public String getUidAttributeID() {
        return this._uidAttributeID;
    }

    public void setRoleAttributeID(String roleAttributeID) {
        this._roleAttributeID = roleAttributeID;
    }

    public String getRoleAttributeID() {
        return this._roleAttributeID;
    }

    public void setCredentialQueryString(String credentialQueryString) {
        this._credentialQueryString = credentialQueryString;
    }

    public String getCredentialQueryString() {
        return this._credentialQueryString;
    }

    public void setUserPropertiesQueryString(String userPropertiesQueryString) {
        this._userPropertiesQueryString = userPropertiesQueryString;
    }

    public String getUserPropertiesQueryString() {
        return this._userPropertiesQueryString;
    }

    public String getUpdateableCredentialAttribute() {
        return this._updateableCredentialAttribute;
    }

    public void setUpdateableCredentialAttribute(String updateableCredentialAttribute) {
        this._updateableCredentialAttribute = updateableCredentialAttribute;
    }
}

