/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.ldap;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.BaseCredential;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.auth.scheme.AuthenticationScheme;
import org.josso.auth.scheme.PasswordCredential;
import org.josso.auth.scheme.UsernameCredential;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.AbstractStore;
import org.josso.gateway.identity.service.store.CertificateUserKey;
import org.josso.gateway.identity.service.store.ExtendedIdentityStore;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;
import org.josso.gateway.session.SSOSession;
import org.josso.selfservices.ChallengeResponseCredential;

public class LDAPIdentityStore
extends AbstractStore
implements ExtendedIdentityStore {
    private static final Log logger = LogFactory.getLog(LDAPIdentityStore.class);
    private static final String USERPASSWORD_SCHEME_MD5 = "{md5}";
    private static final String USERPASSWORD_SCHEME_CRYPT = "{crypt}";
    private static final String USERPASSWORD_SCHEME_SHA = "{sha}";
    private String _initialContextFactory;
    private String _providerUrl;
    private String _securityAuthentication;
    private String _rolesCtxDN;
    private String _uidAttributeID;
    private String _roleAttributeID;
    private String _roleMatchingMode;
    private String _securityProtocol;
    private String _securityPrincipal;
    private String _securityCredential;
    private String _principalUidAttributeID;
    private String _principalLookupAttributeID;
    private String _userCertificateAtrributeID = "userCertificate";
    private String _usersCtxDN;
    private String _credentialQueryString;
    private String _userPropertiesQueryString;
    private String _ldapSearchScope;
    private String _updateableCredentialAttribute;
    private Boolean _useBindCredentials = false;
    private Boolean _enableStartTls = false;
    private String _trustStore;
    private String _trustStorePassword;

    public BaseUser loadUser(UserKey key) throws NoSuchUserException, SSOIdentityException {
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            String uid = this.selectUser(((SimpleUserKey)key).getId());
            if (uid == null) {
                throw new NoSuchUserException(key);
            }
            BaseUserImpl bu = new BaseUserImpl();
            bu.setName(uid);
            ArrayList<SSONameValuePair> userProperties = new ArrayList<SSONameValuePair>();
            if (this.getUserPropertiesQueryString() != null) {
                HashMap userPropertiesResultSet = this.selectUserProperties(((SimpleUserKey)key).getId());
                for (String pName : userPropertiesResultSet.keySet()) {
                    String pValue = (String)userPropertiesResultSet.get(pName);
                    SSONameValuePair vp = new SSONameValuePair(pName, pValue);
                    userProperties.add(vp);
                }
            }
            String dn = this.selectUserDN(((SimpleUserKey)key).getId());
            userProperties.add(new SSONameValuePair("josso.user.dn", dn));
            SSONameValuePair[] props = userProperties.toArray(new SSONameValuePair[userProperties.size()]);
            bu.setProperties(props);
            return bu;
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining user", (Throwable)e);
            throw new SSOIdentityException("Error obtaining user : " + key);
        }
        catch (IOException e) {
            logger.error((Object)"StartTLS error", (Throwable)e);
            throw new SSOIdentityException("StartTLS error : " + e.getMessage());
        }
    }

    public BaseRole[] findRolesByUserKey(UserKey key) throws SSOIdentityException {
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            String[] roleNames = this.selectRolesByUsername(((SimpleUserKey)key).getId());
            ArrayList<BaseRoleImpl> roles = new ArrayList<BaseRoleImpl>();
            for (int i = 0; i < roleNames.length; ++i) {
                String roleName = roleNames[i];
                BaseRoleImpl role = new BaseRoleImpl();
                role.setName(roleName);
                roles.add(role);
            }
            return roles.toArray(new BaseRole[roles.size()]);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining roles", (Throwable)e);
            throw new SSOIdentityException("Error obtaining roles for user : " + key);
        }
        catch (IOException e) {
            logger.error((Object)"StartTLS error", (Throwable)e);
            throw new SSOIdentityException("StartTLS error : " + e.getMessage());
        }
    }

    public String loadUsernameByRelayCredential(ChallengeResponseCredential cred) throws SSOIdentityException {
        try {
            return this.selectUser(cred.getId(), cred.getResponse());
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining user with relay credential", (Throwable)e);
            throw new SSOIdentityException("Error obtaining user with relay credential: ID[" + cred.getId() + "] = RESPONSE[" + cred.getResponse() + "]");
        }
        catch (IOException e) {
            logger.error((Object)"StartTLS error", (Throwable)e);
            throw new SSOIdentityException("StartTLS error : " + e.getMessage());
        }
    }

    public void updateAccountPassword(UserKey key, Credential newPassword) throws SSOIdentityException {
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            BasicAttributes atts = new BasicAttributes();
            atts.put(this.getUpdateableCredentialAttribute(), ((BaseCredential)newPassword).getValue());
            this.replaceAttributes(this.selectUserDN(((SimpleUserKey)key).getId()), atts);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while updating password account", (Throwable)e);
            throw new SSOIdentityException("Error updating password account for user : " + key);
        }
        catch (IOException e) {
            logger.error((Object)"StartTLS error", (Throwable)e);
            throw new SSOIdentityException("StartTLS error : " + e.getMessage());
        }
    }

    public Credential[] loadCredentials(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        try {
            if (!(key instanceof CredentialKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            HashMap credentialResultSet = this.selectCredentials(((SimpleUserKey)key).getId(), cp);
            for (String cName : credentialResultSet.keySet()) {
                List cValues = (List)credentialResultSet.get(cName);
                Iterator valIter = cValues.iterator();
                while (valIter.hasNext()) {
                    Credential c = cp.newCredential(cName, valIter.next());
                    credentials.add(c);
                }
            }
            return credentials.toArray(new Credential[credentialResultSet.size()]);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException while obtaining Credentials", (Throwable)e);
            throw new SSOIdentityException("Error obtaining credentials for user : " + key);
        }
        catch (IOException e) {
            logger.error((Object)"StartTLS error", (Throwable)e);
            throw new SSOIdentityException("StartTLS error : " + e.getMessage());
        }
    }

    public String loadUID(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        try {
            if (key instanceof CertificateUserKey) {
                return this.loadUID(((CertificateUserKey)key).getId(), ((CertificateUserKey)key).getCertificate(), cp);
            }
            if (key instanceof SimpleUserKey) {
                return ((SimpleUserKey)key).getId();
            }
            throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to locate user", (Throwable)e);
            throw new SSOIdentityException("Failed to locate user for certificate : " + ((CertificateUserKey)key).getCertificate().getSubjectX500Principal().getName());
        }
        catch (IOException e) {
            logger.error((Object)"StartTLS error", (Throwable)e);
            throw new SSOIdentityException("StartTLS error : " + e.getMessage());
        }
    }

    public boolean userExists(UserKey key) throws SSOIdentityException {
        if (this.getUseBindCredentials().booleanValue()) {
            String uid = null;
            try {
                uid = this.selectUser(((SimpleUserKey)key).getId());
            }
            catch (NamingException e) {
                logger.error((Object)"NamingException while obtaining user", (Throwable)e);
                throw new SSOIdentityException("Error obtaining user : " + key);
            }
            catch (IOException e) {
                logger.error((Object)"StartTLS error", (Throwable)e);
                throw new SSOIdentityException("StartTLS error : " + e.getMessage());
            }
            return uid != null;
        }
        return super.userExists(key);
    }

    protected String[] selectRolesByUsername(String username) throws NamingException, IOException {
        StartTlsResponse tls;
        InitialLdapContext ctx;
        ArrayList<String> userRoles;
        block19: {
            String rolesCtxDN;
            userRoles = new ArrayList<String>();
            ctx = null;
            try {
                ctx = this.createLdapInitialContext(this.getUseBindCredentials());
            }
            catch (NamingException e) {
                if (this.getUseBindCredentials().booleanValue()) {
                    return userRoles.toArray(new String[userRoles.size()]);
                }
                throw e;
            }
            tls = null;
            if (this.getEnableStartTls().booleanValue()) {
                tls = this.startTls(ctx);
            }
            if ((rolesCtxDN = this.getRolesCtxDN()) != null) {
                String userDN;
                String roleAttrName;
                String uidAttributeID = this.getUidAttributeID();
                if (uidAttributeID == null) {
                    uidAttributeID = "uniquemember";
                }
                if ((roleAttrName = this.getRoleAttributeID()) == null) {
                    roleAttrName = "roles";
                }
                if ((userDN = "UID".equals(this.getRoleMatchingMode()) ? username : this.selectUserDN(username)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Searching Roles for user '" + userDN + "' in Uid attribute name '" + uidAttributeID + "'"));
                    }
                    try {
                        if (userDN.contains("\\")) {
                            logger.debug((Object)"Escaping '\\' character");
                            userDN = userDN.replace("\\", "\\\\\\");
                        }
                        NamingEnumeration<SearchResult> answer = ctx.search(rolesCtxDN, "(&(" + uidAttributeID + "=" + userDN + "))", this.getSearchControls());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Search Name:  " + rolesCtxDN));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Search Filter:  (&(" + uidAttributeID + "=" + userDN + "))"));
                        }
                        if (!answer.hasMore()) {
                            logger.info((Object)("No role where found for user " + username));
                        }
                        while (answer.hasMore()) {
                            SearchResult sr = answer.next();
                            Attributes attrs = sr.getAttributes();
                            Attribute roles = attrs.get(roleAttrName);
                            for (int r = 0; r < roles.size(); ++r) {
                                Object value = roles.get(r);
                                String roleName = null;
                                roleName = value.toString();
                                if (roleName == null) continue;
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Saving role '" + roleName + "' for user '" + username + "'"));
                                }
                                userRoles.add(roleName);
                            }
                        }
                    }
                    catch (NamingException e) {
                        if (!logger.isDebugEnabled()) break block19;
                        logger.debug((Object)"Failed to locate roles", (Throwable)e);
                    }
                }
            }
        }
        if (tls != null) {
            tls.close();
        }
        ctx.close();
        return userRoles.toArray(new String[userRoles.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectUserDN(String uid) throws NamingException, IOException {
        String dn = null;
        InitialLdapContext ctx = this.createLdapInitialContext(false);
        StartTlsResponse tls = null;
        if (this.getEnableStartTls().booleanValue()) {
            tls = this.startTls(ctx);
        }
        String principalUidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalUidAttrName + "=" + uid + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute uidAttr = attrs.get(principalUidAttrName);
                if (uidAttr == null) {
                    logger.warn((Object)("Invalid user uid attribute '" + principalUidAttrName + "'"));
                    continue;
                }
                String uidValue = uidAttr.get().toString();
                if (uidValue != null) {
                    dn = sr.getName() + "," + usersCtxDN;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user '" + principalUidAttrName + "=" + uidValue + "' for user '" + uid + "' DN=" + dn));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("User not found for user '" + uid + "'"));
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            if (tls != null) {
                tls.close();
            }
            ctx.close();
        }
        return dn;
    }

    protected String selectUser(String uid) throws NamingException, IOException {
        return this.selectUser(this.getPrincipalUidAttributeID(), uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectUser(String attrId, String attrValue) throws NamingException, IOException {
        String uidValue = null;
        InitialLdapContext ctx = this.createLdapInitialContext(false);
        StartTlsResponse tls = null;
        if (this.getEnableStartTls().booleanValue()) {
            tls = this.startTls(ctx);
        }
        BasicAttributes matchAttrs = new BasicAttributes(true);
        String uidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        matchAttrs.put(attrId, attrValue);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + attrId + "=" + attrValue + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute uidAttr = attrs.get(uidAttrName);
                if (uidAttr == null) {
                    logger.warn((Object)("Invalid user attrValue attribute '" + uidAttrName + "'"));
                    continue;
                }
                uidValue = uidAttr.get().toString();
                if (uidValue != null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user '" + uidAttrName + "=" + uidValue + "' for user '" + attrValue + "'"));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("User not found for user '" + attrValue + "'"));
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            if (tls != null) {
                tls.close();
            }
            ctx.close();
        }
        return uidValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap selectCredentials(String uid, CredentialProvider cp) throws NamingException, IOException {
        String principalLookupAttrName;
        HashMap credentialResultSet = new HashMap();
        InitialLdapContext ctx = this.createLdapInitialContext(false);
        StartTlsResponse tls = null;
        if (this.getEnableStartTls().booleanValue()) {
            tls = this.startTls(ctx);
        }
        String schemeName = null;
        if (cp instanceof AuthenticationScheme) {
            schemeName = ((AuthenticationScheme)cp).getName();
        }
        if ((principalLookupAttrName = this.getPrincipalLookupAttributeID()) == null || principalLookupAttrName.trim().equals("") || !"strong-authentication".equals(schemeName)) {
            principalLookupAttrName = this.getPrincipalUidAttributeID();
        }
        String usersCtxDN = this.getUsersCtxDN();
        String credentialQueryString = this.getCredentialQueryString();
        HashMap credentialQueryMap = this.parseQueryString(credentialQueryString);
        Iterator i = credentialQueryMap.keySet().iterator();
        ArrayList<String> credentialAttrList = new ArrayList<String>();
        while (i.hasNext()) {
            String o = (String)i.next();
            credentialAttrList.add(o);
        }
        String[] credentialAttr = credentialAttrList.toArray(new String[credentialAttrList.size()]);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalLookupAttrName + "=" + uid + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                String userDN = sr.getNameInNamespace();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing results for entry '" + userDN + "'"));
                }
                for (int j = 0; j < credentialAttr.length; ++j) {
                    if (attrs.get(credentialAttr[j]) == null) continue;
                    String credentialName = (String)credentialQueryMap.get(credentialAttr[j]);
                    String credentialValue = null;
                    Attribute attr = attrs.get(credentialAttr[j]);
                    NamingEnumeration<?> attrEnum = attr.getAll();
                    while (attrEnum.hasMore()) {
                        ArrayList credentials;
                        Object credentialObject = attrEnum.next();
                        if (credentialObject == null) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found user credential '" + credentialName + "' of type '" + credentialObject.getClass().getName() + "" + (credentialObject.getClass().isArray() ? "[" + Array.getLength(credentialObject) + "]" : "") + "'"));
                        }
                        if (credentialObject.getClass().isArray()) {
                            try {
                                byte[] credentialData = (byte[])credentialObject;
                                ByteBuffer in = ByteBuffer.allocate(credentialData.length);
                                in.put(credentialData);
                                in.flip();
                                Charset charset = Charset.forName("UTF-8");
                                CharsetDecoder decoder = charset.newDecoder();
                                CharBuffer charBuffer = decoder.decode(in);
                                credentialValue = charBuffer.toString();
                            }
                            catch (CharacterCodingException e) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Can't convert credential value to String using UTF-8");
                                }
                            }
                        } else if (credentialObject instanceof String) {
                            credentialValue = (String)credentialObject;
                        }
                        if ((credentials = (ArrayList)credentialResultSet.get(credentialName)) == null) {
                            credentials = new ArrayList();
                        }
                        if (credentialValue != null) {
                            credentialValue = this.getSchemeFreeValue(credentialValue);
                            credentials.add(credentialValue);
                        } else {
                            credentials.add(credentialObject);
                        }
                        credentialResultSet.put(credentialName, credentials);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Found user credential '" + credentialName + "' with value '" + (credentialValue != null ? credentialValue : credentialObject) + "'"));
                    }
                }
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            if (tls != null) {
                tls.close();
            }
            ctx.close();
        }
        return credentialResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadUID(String lookupValue, X509Certificate certificate, CredentialProvider cp) throws NamingException, IOException {
        String principalLookupAttrName;
        String uidValue = null;
        InitialLdapContext ctx = this.createLdapInitialContext(false);
        StartTlsResponse tls = null;
        if (this.getEnableStartTls().booleanValue()) {
            tls = this.startTls(ctx);
        }
        String schemeName = null;
        if (cp instanceof AuthenticationScheme) {
            schemeName = ((AuthenticationScheme)cp).getName();
        }
        if ((principalLookupAttrName = this.getPrincipalLookupAttributeID()) == null || principalLookupAttrName.trim().equals("") || !"strong-authentication".equals(schemeName)) {
            principalLookupAttrName = this.getPrincipalUidAttributeID();
        }
        String principalUidAttrName = this.getPrincipalUidAttributeID();
        String certificateAttrName = this.getUserCertificateAtrributeID();
        String usersCtxDN = this.getUsersCtxDN();
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalLookupAttrName + "={0})(" + certificateAttrName + "={1}))", new Object[]{lookupValue, certificate.getEncoded()}, this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute uidAttr = attrs.get(principalUidAttrName);
                if (uidAttr == null) {
                    logger.warn((Object)("Invalid user uid attribute '" + principalUidAttrName + "'"));
                    continue;
                }
                uidValue = uidAttr.get().toString();
                if (uidValue != null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user " + principalUidAttrName + "=" + uidValue));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("User not found for certificate '" + certificate.getSubjectX500Principal().getName() + "'"));
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        catch (CertificateEncodingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Certificate encoding exception", (Throwable)e);
            }
        }
        finally {
            if (tls != null) {
                tls.close();
            }
            ctx.close();
        }
        return uidValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap selectUserProperties(String uid) throws NamingException, IOException {
        HashMap<String, String> userPropertiesResultSet = new HashMap<String, String>();
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLdapInitialContext(this.getUseBindCredentials());
        }
        catch (NamingException e) {
            if (this.getUseBindCredentials().booleanValue()) {
                return userPropertiesResultSet;
            }
            throw e;
        }
        StartTlsResponse tls = null;
        if (this.getEnableStartTls().booleanValue()) {
            tls = this.startTls(ctx);
        }
        BasicAttributes matchAttrs = new BasicAttributes(true);
        String principalUidAttrName = this.getPrincipalUidAttributeID();
        String usersCtxDN = this.getUsersCtxDN();
        matchAttrs.put(principalUidAttrName, uid);
        String userPropertiesQueryString = this.getUserPropertiesQueryString();
        HashMap userPropertiesQueryMap = this.parseQueryString(userPropertiesQueryString);
        Iterator i = userPropertiesQueryMap.keySet().iterator();
        ArrayList<String> propertiesAttrList = new ArrayList<String>();
        while (i.hasNext()) {
            String o = (String)i.next();
            propertiesAttrList.add(o);
        }
        String[] propertiesAttr = propertiesAttrList.toArray(new String[propertiesAttrList.size()]);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(usersCtxDN, "(&(" + principalUidAttrName + "=" + uid + "))", this.getSearchControls());
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                for (int j = 0; j < propertiesAttr.length; ++j) {
                    Attribute attribute = attrs.get(propertiesAttr[j]);
                    if (attribute == null) {
                        logger.warn((Object)("Invalid user property attribute '" + propertiesAttr[j] + "'"));
                        continue;
                    }
                    Object propertyObject = attrs.get(propertiesAttr[j]).get();
                    if (propertyObject == null) {
                        logger.warn((Object)("Found a 'null' value for user property '" + propertiesAttr[j] + "'"));
                        continue;
                    }
                    String propertyValue = propertyObject.toString();
                    String propertyName = (String)userPropertiesQueryMap.get(propertiesAttr[j]);
                    userPropertiesResultSet.put(propertyName, propertyValue);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found user property '" + propertyName + "' with value '" + propertyValue + "'"));
                }
            }
        }
        catch (NamingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to locate user", (Throwable)e);
            }
        }
        finally {
            if (tls != null) {
                tls.close();
            }
            ctx.close();
        }
        return userPropertiesResultSet;
    }

    protected void replaceAttributes(String bane, Attributes atts) throws NamingException, IOException {
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLdapInitialContext(this.getUseBindCredentials());
        }
        catch (NamingException e) {
            if (this.getUseBindCredentials().booleanValue()) {
                return;
            }
            throw e;
        }
        ctx.modifyAttributes(bane, 2, atts);
    }

    protected InitialLdapContext createLdapInitialContext(Boolean useBindCredentials) throws NamingException, IOException {
        String securityCredential;
        String securityPrincipal = this.getSecurityPrincipal();
        if (securityPrincipal == null) {
            securityPrincipal = "";
        }
        if ((securityCredential = this.getSecurityCredential()) == null) {
            securityCredential = "";
        }
        SSOSession session = SSOContext.getCurrent().getSession();
        if (useBindCredentials.booleanValue() && session != null) {
            String username = this.getUsername(session.getSubject().getPublicCredentials());
            securityPrincipal = this.selectUserDN(username);
            if (securityPrincipal == null) {
                throw new NamingException("User not found.");
            }
            securityCredential = this.getPassword(session.getSubject().getPrivateCredentials());
        }
        return this.createLdapInitialContext(securityPrincipal, securityCredential);
    }

    protected InitialLdapContext createLdapInitialContext(String securityPrincipal, String securityCredential) throws NamingException {
        String authType;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.getInitialContextFactory());
        env.setProperty("java.naming.security.authentication", this.getSecurityAuthentication());
        env.setProperty("java.naming.provider.url", this.getProviderUrl());
        env.setProperty("java.naming.security.protocol", this.getSecurityProtocol() == null ? "" : this.getSecurityProtocol());
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = this.getProviderUrl();
        if (providerURL == null) {
            providerURL = protocol != null && protocol.equals("ssl") ? "ldaps://localhost:636" : "ldap://localhost:389";
        }
        env.setProperty("java.naming.provider.url", providerURL);
        env.setProperty("java.naming.security.principal", securityPrincipal);
        env.put("java.naming.security.credentials", securityCredential);
        env.put("java.naming.referral", "follow");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Logging into LDAP server, env=" + env));
        }
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Logged into LDAP server, " + ctx));
        }
        return ctx;
    }

    protected StartTlsResponse startTls(InitialLdapContext ctx) throws NamingException, IOException {
        if (this.getTrustStore() != null && !this.getTrustStore().equals("")) {
            System.setProperty("javax.net.ssl.trustStore", this.getTrustStore());
        }
        if (this.getTrustStorePassword() != null && !this.getTrustStorePassword().equals("")) {
            System.setProperty("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
        }
        StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        tls.negotiate();
        return tls;
    }

    protected String getUsername(Set credentials) {
        UsernameCredential c = this.getUsernameCredential(credentials);
        if (c == null) {
            return null;
        }
        return (String)c.getValue();
    }

    protected UsernameCredential getUsernameCredential(Set credentials) {
        for (Credential credential : credentials) {
            if (!(credential instanceof UsernameCredential)) continue;
            return (UsernameCredential)credential;
        }
        return null;
    }

    protected String getPassword(Set credentials) {
        PasswordCredential p = this.getPasswordCredential(credentials);
        if (p == null) {
            return null;
        }
        return (String)p.getValue();
    }

    protected PasswordCredential getPasswordCredential(Set credentials) {
        for (Credential credential : credentials) {
            if (!(credential instanceof PasswordCredential)) continue;
            return (PasswordCredential)credential;
        }
        return null;
    }

    protected String getSchemeFreeValue(String attributeValue) {
        String targetValue = attributeValue;
        if (attributeValue.toLowerCase().startsWith(USERPASSWORD_SCHEME_CRYPT)) {
            targetValue = attributeValue.substring(USERPASSWORD_SCHEME_CRYPT.length());
        } else if (attributeValue.toLowerCase().startsWith(USERPASSWORD_SCHEME_MD5)) {
            targetValue = attributeValue.substring(USERPASSWORD_SCHEME_MD5.length());
        } else if (attributeValue.toLowerCase().startsWith(USERPASSWORD_SCHEME_SHA)) {
            targetValue = attributeValue.substring(USERPASSWORD_SCHEME_SHA.length());
        }
        return targetValue;
    }

    protected HashMap parseQueryString(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = pair.substring(0, pos);
            String val = pair.substring(pos + 1, pair.length());
            hm.put(key, val);
        }
        return hm;
    }

    protected SearchControls getSearchControls() {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(this._ldapSearchScope == null || this._ldapSearchScope.equalsIgnoreCase("ONELEVEL") ? 1 : 2);
        return sc;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this._initialContextFactory = initialContextFactory;
    }

    public String getInitialContextFactory() {
        return this._initialContextFactory;
    }

    public void setProviderUrl(String providerUrl) {
        this._providerUrl = providerUrl;
    }

    public String getProviderUrl() {
        return this._providerUrl;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this._securityAuthentication = securityAuthentication;
    }

    public String getSecurityAuthentication() {
        return this._securityAuthentication;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this._securityProtocol = securityProtocol;
    }

    public String getSecurityProtocol() {
        return this._securityProtocol;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this._securityPrincipal = securityPrincipal;
    }

    public String getSecurityPrincipal() {
        return this._securityPrincipal;
    }

    public void setSecurityCredential(String securityCredential) {
        this._securityCredential = securityCredential;
    }

    protected String getSecurityCredential() {
        return this._securityCredential;
    }

    public String getLdapSearchScope() {
        return this._ldapSearchScope;
    }

    public void setLdapSearchScope(String ldapSearchScope) {
        this._ldapSearchScope = ldapSearchScope;
    }

    public void setUsersCtxDN(String usersCtxDN) {
        this._usersCtxDN = usersCtxDN;
    }

    public String getUsersCtxDN() {
        return this._usersCtxDN;
    }

    public void setRolesCtxDN(String rolesCtxDN) {
        this._rolesCtxDN = rolesCtxDN;
    }

    public String getRolesCtxDN() {
        return this._rolesCtxDN;
    }

    public void setPrincipalUidAttributeID(String principalUidAttributeID) {
        this._principalUidAttributeID = principalUidAttributeID;
    }

    public String getPrincipalUidAttributeID() {
        return this._principalUidAttributeID;
    }

    public void setUidAttributeID(String uidAttributeID) {
        this._uidAttributeID = uidAttributeID;
    }

    public void setPrincipalLookupAttributeID(String principalLookupAttributeID) {
        this._principalLookupAttributeID = principalLookupAttributeID;
    }

    public String getPrincipalLookupAttributeID() {
        return this._principalLookupAttributeID;
    }

    public void setUserCertificateAtrributeID(String userCertificateAtrributeID) {
        this._userCertificateAtrributeID = userCertificateAtrributeID;
    }

    public String getUserCertificateAtrributeID() {
        return this._userCertificateAtrributeID;
    }

    public String getRoleMatchingMode() {
        return this._roleMatchingMode;
    }

    public void setRoleMatchingMode(String roleMatchingMode) {
        this._roleMatchingMode = roleMatchingMode;
    }

    public String getUidAttributeID() {
        return this._uidAttributeID;
    }

    public void setRoleAttributeID(String roleAttributeID) {
        this._roleAttributeID = roleAttributeID;
    }

    public String getRoleAttributeID() {
        return this._roleAttributeID;
    }

    public void setCredentialQueryString(String credentialQueryString) {
        this._credentialQueryString = credentialQueryString;
    }

    public String getCredentialQueryString() {
        return this._credentialQueryString;
    }

    public void setUserPropertiesQueryString(String userPropertiesQueryString) {
        this._userPropertiesQueryString = userPropertiesQueryString;
    }

    public String getUserPropertiesQueryString() {
        return this._userPropertiesQueryString;
    }

    public String getUpdateableCredentialAttribute() {
        return this._updateableCredentialAttribute;
    }

    public void setUpdateableCredentialAttribute(String updateableCredentialAttribute) {
        this._updateableCredentialAttribute = updateableCredentialAttribute;
    }

    public Boolean getUseBindCredentials() {
        return this._useBindCredentials;
    }

    public void setUseBindCredentials(Boolean useBindCredentials) {
        this._useBindCredentials = useBindCredentials;
    }

    public Boolean getEnableStartTls() {
        return this._enableStartTls;
    }

    public void setEnableStartTls(Boolean enableStartTls) {
        this._enableStartTls = enableStartTls;
    }

    public String getTrustStore() {
        return this._trustStore;
    }

    public void setTrustStore(String trustStore) {
        this._trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this._trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this._trustStorePassword = trustStorePassword;
    }
}

