/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.BaseSession;
import org.josso.gateway.session.service.store.AbstractSessionStore;

public class MemorySessionStore
extends AbstractSessionStore {
    private static final Log logger = LogFactory.getLog(MemorySessionStore.class);
    private Map _sessions = new HashMap();
    private Map _sessionsByUsername = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws SSOSessionException {
        Map map = this._sessions;
        synchronized (map) {
            return this._sessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws SSOSessionException {
        Map map = this._sessions;
        synchronized (map) {
            return this._sessions.keySet().toArray(new String[this._sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSession[] loadAll() throws SSOSessionException {
        Map map = this._sessions;
        synchronized (map) {
            return this._sessions.values().toArray(new BaseSession[this._sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSession load(String id) throws SSOSessionException {
        BaseSession s = null;
        Map map = this._sessions;
        synchronized (map) {
            s = (BaseSession)this._sessions.get(id);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[load(" + id + ")] Session " + (s == null ? " not" : "") + " found"));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSession[] loadByUsername(String name) throws SSOSessionException {
        BaseSession[] result;
        Map map = this._sessions;
        synchronized (map) {
            HashSet sessions = (HashSet)this._sessionsByUsername.get(name);
            if (sessions == null) {
                sessions = new HashSet();
            }
            result = sessions.toArray(new BaseSession[sessions.size()]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[loadByUsername(" + name + ")] Sessions found =  " + result.length));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSession[] loadByLastAccessTime(Date time) throws SSOSessionException {
        ArrayList<BaseSession> results = new ArrayList<BaseSession>();
        Map map = this._sessions;
        synchronized (map) {
            Collection sessions = this._sessions.values();
            for (BaseSession session : sessions) {
                if (session.getLastAccessTime() >= time.getTime()) continue;
                results.add(session);
            }
        }
        return results.toArray(new BaseSession[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSession[] loadByValid(boolean valid) throws SSOSessionException {
        ArrayList<BaseSession> results = new ArrayList<BaseSession>();
        Map map = this._sessions;
        synchronized (map) {
            Collection sessions = this._sessions.values();
            for (BaseSession session : sessions) {
                if (session.isValid() != valid) continue;
                results.add(session);
            }
        }
        return results.toArray(new BaseSession[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) throws SSOSessionException {
        BaseSession session = null;
        Map map = this._sessions;
        synchronized (map) {
            session = (BaseSession)this._sessions.remove(id);
            if (session != null && session.getUsername() != null) {
                Set userSessions = (Set)this._sessionsByUsername.get(session.getUsername());
                userSessions.remove(session);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[remove(" + id + ")] Session " + (session == null ? " not" : "") + " found"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws SSOSessionException {
        Map map = this._sessions;
        synchronized (map) {
            this._sessions.clear();
            this._sessionsByUsername.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BaseSession session) throws SSOSessionException {
        BaseSession oldSession = null;
        Map map = this._sessions;
        synchronized (map) {
            Set userSessions;
            String oldUsername;
            oldSession = this._sessions.put(session.getId(), session);
            if (oldSession != null && (oldUsername = oldSession.getUsername()) != null && (userSessions = (Set)this._sessionsByUsername.get(oldUsername)) != null) {
                userSessions.remove(oldSession);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing old session from reverse map : " + oldSession.getId() + ". user=" + oldUsername));
                }
            }
            if (session.getUsername() != null) {
                HashSet<BaseSession> sessions = (HashSet<BaseSession>)this._sessionsByUsername.get(session.getUsername());
                if (sessions == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Building new set for user " + session.getUsername()));
                    }
                    sessions = new HashSet<BaseSession>();
                    this._sessionsByUsername.put(session.getUsername(), sessions);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding session to reverse map : " + session.getId() + ". user=" + session.getUsername()));
                }
                sessions.add(session);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[save(BaseSession." + session.getId() + ")] Session " + (oldSession == null ? " inserted" : "") + " updated"));
        }
    }
}

