/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.scheme.NtlmDomainControllerCredential;
import org.josso.auth.scheme.NtlmPasswordAuthenticationCredential;

public class NtlmCredentialProvider
implements CredentialProvider {
    private static final Log logger = LogFactory.getLog(NtlmCredentialProvider.class);
    public static final String DOMAIN_CONTROLLER_CREDENTIAL = "UniAddress";
    public static final String PASSWORD_AUTHENTICATION_CREDENTIAL = "NtlmPasswordAuthentication";

    public Credential newCredential(String name, Object value) {
        if (name.equals(DOMAIN_CONTROLLER_CREDENTIAL)) {
            return new NtlmDomainControllerCredential(value);
        }
        if (name.equals(PASSWORD_AUTHENTICATION_CREDENTIAL)) {
            return new NtlmPasswordAuthenticationCredential(value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unknown credential name: " + name));
        }
        return null;
    }

    public Credential newEncodedCredential(String name, Object value) {
        return this.newCredential(name, value);
    }

    public static Credential retreiveCredential(String name, Credential[] credentials) {
        for (Credential c : credentials) {
            if (c instanceof NtlmPasswordAuthenticationCredential && name.equals(PASSWORD_AUTHENTICATION_CREDENTIAL)) {
                return c;
            }
            if (!(c instanceof NtlmDomainControllerCredential) || !name.equals(DOMAIN_CONTROLLER_CREDENTIAL)) continue;
            return c;
        }
        return null;
    }

    public static String retreiveCredentialName(String name, Credential[] credentials) {
        Credential c = NtlmCredentialProvider.retreiveCredential(name, credentials);
        return c == null ? "" : c.toString();
    }
}

