/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.protocol.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.http.NtlmSsp;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.auth.BaseCredential;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.scheme.NtlmPasswordAuthenticationCredential;
import org.josso.gateway.protocol.handler.ProtocolHandler;

public class NtlmProtocolHandler
implements ProtocolHandler {
    private static final Log logger = LogFactory.getLog(NtlmProtocolHandler.class);
    public static final String NTLM_DOMAIN_CONTROLLER = "ntlmHttpDc";
    public static final String NTLM_PASS_AUTHENTICATION = "ntlmHttpPa";
    public static final String NTLM_ERROR_FLAG = "ntlm_error";
    private String defaultDomain;
    private String domainController;
    private boolean loadBalance;
    private boolean enableBasic;
    private boolean insecureBasic;
    private String realm;

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public String getDomainController() {
        return this.domainController;
    }

    public void setDomainController(String domainController) {
        this.domainController = domainController;
    }

    public boolean getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(String loadBalance) {
        this.setLoadBalance(Boolean.getBoolean(loadBalance));
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public boolean getEnableBasic() {
        return this.enableBasic;
    }

    public void setEnableBasic(String enableBasic) {
        this.setEnableBasic(Boolean.getBoolean(enableBasic));
    }

    public void setEnableBasic(boolean enableBasic) {
        this.enableBasic = enableBasic;
    }

    public boolean getInsecureBasic() {
        return this.insecureBasic;
    }

    public void setInsecureBasic(String insecureBasic) {
        this.setInsecureBasic(Boolean.getBoolean(insecureBasic));
    }

    public void setInsecureBasic(boolean insecureBasic) {
        this.insecureBasic = insecureBasic;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    private boolean isOfferBasic(HttpServletRequest req) {
        return this.enableBasic && (this.insecureBasic || req.isSecure());
    }

    public NtlmProtocolHandler() {
        Config.setProperty((String)"jcifs.smb.client.soTimeout", (String)"500");
    }

    public static NtlmProtocolHandler getInstance() throws Exception {
        return (NtlmProtocolHandler)Lookup.getInstance().lookupSecurityDomain().getProtocolManager().retreiveHandler(NtlmProtocolHandler.class.getName());
    }

    public boolean acceptJob(HttpServletRequest request, HttpServletResponse response) {
        try {
            NtlmProtocolHandler ntlmProtocolHandler = (NtlmProtocolHandler)Lookup.getInstance().lookupSecurityDomain().getProtocolManager().retreiveHandler(NtlmProtocolHandler.class.getName());
            return ntlmProtocolHandler != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean doJob(HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.negotiate(request, response, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean authenticate(Credential[] credentials) throws AuthenticationFailureException {
        try {
            return this.authenticateCredentials(credentials);
        }
        catch (SmbException se) {
            throw new AuthenticationFailureException(se.getMessage(), Integer.toHexString(se.getNtStatus()));
        }
    }

    protected boolean negotiate(HttpServletRequest req, HttpServletResponse resp, boolean skipAuthentication) throws IOException, ServletException {
        HttpSession ssn;
        String msg = req.getHeader("Authorization");
        Object error = req.getAttribute(NTLM_ERROR_FLAG);
        if (error != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Restarts negotiation due to authentication error");
            }
            req.removeAttribute(NTLM_ERROR_FLAG);
            this.startsNegotiation(req, resp);
            return false;
        }
        if (msg != null && (msg.startsWith("NTLM ") || this.isOfferBasic(req) && msg.startsWith("Basic "))) {
            NtlmPasswordAuthentication ntlm;
            UniAddress dc;
            if (msg.startsWith("NTLM ")) {
                byte[] challenge;
                HttpSession ssn2 = req.getSession();
                if (this.loadBalance) {
                    NtlmChallenge chal = (NtlmChallenge)ssn2.getAttribute("NtlmHttpChal");
                    if (chal == null) {
                        chal = SmbSession.getChallengeForDomain();
                        ssn2.setAttribute("NtlmHttpChal", (Object)chal);
                    }
                    dc = chal.dc;
                    challenge = chal.challenge;
                } else {
                    dc = UniAddress.getByName((String)this.domainController, (boolean)true);
                    challenge = SmbSession.getChallenge((UniAddress)dc);
                }
                ntlm = NtlmSsp.authenticate((HttpServletRequest)req, (HttpServletResponse)resp, (byte[])challenge);
                if (ntlm == null) {
                    return false;
                }
                ssn2.removeAttribute("NtlmHttpChal");
            } else {
                String auth = new String(Base64.decode((String)msg.substring(6)), "US-ASCII");
                int index = auth.indexOf(58);
                String user = index != -1 ? auth.substring(0, index) : auth;
                String password = index != -1 ? auth.substring(index + 1) : "";
                index = user.indexOf(92);
                if (index == -1) {
                    index = user.indexOf(47);
                }
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                user = index != -1 ? user.substring(index + 1) : user;
                ntlm = new NtlmPasswordAuthentication(domain, user, password);
                dc = UniAddress.getByName((String)this.domainController, (boolean)true);
            }
            req.getSession().setAttribute(NTLM_DOMAIN_CONTROLLER, (Object)dc);
            req.getSession().setAttribute(NTLM_PASS_AUTHENTICATION, (Object)ntlm);
        } else if (!(skipAuthentication || (ssn = req.getSession(false)) != null && ssn.getAttribute(NTLM_PASS_AUTHENTICATION) != null)) {
            this.startsNegotiation(req, resp);
            return false;
        }
        return true;
    }

    private void startsNegotiation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "NTLM");
        if (this.isOfferBasic(request)) {
            response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        }
        response.setStatus(401);
        response.setContentLength(0);
        response.flushBuffer();
    }

    private boolean authenticateCredentials(Credential[] credentials) throws SmbException {
        if (credentials.length != 2) {
            logger.error((Object)("Spected 2 credencials, received " + credentials.length));
            return false;
        }
        Object o1 = ((BaseCredential)credentials[0]).getValue();
        Object o2 = ((BaseCredential)credentials[1]).getValue();
        if (o1 == null || o2 == null) {
            logger.error((Object)"Some or all of the credential values are null");
            return false;
        }
        if (o1 instanceof UniAddress && o2 instanceof NtlmPasswordAuthentication) {
            return this.authenticate((UniAddress)o1, (NtlmPasswordAuthentication)o2);
        }
        if (o2 instanceof UniAddress && o1 instanceof NtlmPasswordAuthentication) {
            return this.authenticate((UniAddress)o2, (NtlmPasswordAuthentication)o1);
        }
        logger.error((Object)"The credential types could not be managed");
        logger.error((Object)("  Credential 1 is " + o1));
        logger.error((Object)("  Credential 2 is " + o2));
        return false;
    }

    private boolean authenticate(UniAddress dc, NtlmPasswordAuthentication ntlm) throws SmbException {
        SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[authenticate()]" + ntlm + " successfully authenticated against " + dc));
        }
        return true;
    }

    public static String getPasswordAuthentication(NtlmPasswordAuthenticationCredential credential) {
        NtlmPasswordAuthentication pa = (NtlmPasswordAuthentication)credential.getValue();
        return pa == null ? "" : pa.getUsername();
    }

    public String toString() {
        return "{ [Default Domain=" + this.defaultDomain + "] [Domain Controller=" + this.domainController + "] [Load Balance=" + this.loadBalance + "] [Enable Basic=" + this.enableBasic + "] [Insecure Basic=" + this.insecureBasic + "] [Realm=" + this.realm + "] }";
    }
}

