/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.protocol.handler.NtlmProtocolHandler;
import org.josso.gateway.signon.LoginAction;

public class NtlmLoginAction
extends LoginAction {
    private static final Log logger = LogFactory.getLog(NtlmLoginAction.class);

    protected Credential[] getCredentials(HttpServletRequest request) throws SSOAuthenticationException {
        SSOGateway g = this.getSSOGateway();
        Credential dc = g.newCredential(this.getSchemeName(request), "UniAddress", request.getSession().getAttribute("ntlmHttpDc"));
        Credential pa = g.newCredential(this.getSchemeName(request), "NtlmPasswordAuthentication", request.getSession().getAttribute("ntlmHttpPa"));
        return new Credential[]{dc, pa};
    }

    protected String getSchemeName(HttpServletRequest request) throws SSOAuthenticationException {
        return "ntlm-authentication";
    }

    protected boolean onLoginAuthenticationException(AuthenticationFailureException e, HttpServletRequest request, HttpServletResponse response, Credential[] credentials) throws IOException {
        HttpSession ssn = request.getSession(true);
        if (ssn.getAttribute("ntlmHttpPa") != null) {
            ssn.removeAttribute("ntlmHttpPa");
        }
        try {
            request.setAttribute("ntlm_error", (Object)"ERROR");
            NtlmProtocolHandler.getInstance().doJob(request, response);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("  [onLoginAuthenticationException()] " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }
}

