/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.identity.exceptions.IdentityProvisioningException;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.ws._1_1.protocol.AssertIdentityWithSimpleAuthenticationRequestType;
import org.josso.gateway.ws._1_1.protocol.AssertIdentityWithSimpleAuthenticationResponseType;
import org.josso.gateway.ws._1_1.protocol.AssertionNotValidErrorType;
import org.josso.gateway.ws._1_1.protocol.GlobalSignoffRequestType;
import org.josso.gateway.ws._1_1.protocol.GlobalSignoffResponseType;
import org.josso.gateway.ws._1_1.protocol.ResolveAuthenticationAssertionRequestType;
import org.josso.gateway.ws._1_1.protocol.ResolveAuthenticationAssertionResponseType;
import org.josso.gateway.ws._1_1.protocol.SSOIdentityProviderErrorType;
import org.josso.gateway.ws._1_1.wsdl.SSOIdentityProvider;

public class WebserviceSSOIdentityProvider
implements SSOIdentityProviderService {
    private static final Log logger = LogFactory.getLog(WebserviceSSOIdentityProvider.class);
    private SSOIdentityProvider _wsSSOIdentityProvider;
    private int _errorCount;
    private int _processedCount;

    public WebserviceSSOIdentityProvider(SSOIdentityProvider wsSSOIdentityProvider) {
        this._wsSSOIdentityProvider = wsSSOIdentityProvider;
    }

    public void initialize() {
    }

    public String assertIdentityWithSimpleAuthentication(String securityDomain, String username, String password) throws IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[assertIdentityWithSimpleAuthentication()] : " + username));
            }
            AssertIdentityWithSimpleAuthenticationRequestType request = new AssertIdentityWithSimpleAuthenticationRequestType();
            request.setSecurityDomain(securityDomain);
            request.setUsername(username);
            request.setPassword(password);
            AssertIdentityWithSimpleAuthenticationResponseType response = this._wsSSOIdentityProvider.assertIdentityWithSimpleAuthentication(request);
            String string = response.getAssertionId();
            return string;
        }
        catch (SSOIdentityProviderErrorType e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public String resolveAuthenticationAssertion(String authenticationAssertionId) throws AssertionNotValidException, IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[resolveAuthenticationAssertion()] : " + authenticationAssertionId));
            }
            ResolveAuthenticationAssertionRequestType request = new ResolveAuthenticationAssertionRequestType();
            request.setAssertionId(authenticationAssertionId);
            ResolveAuthenticationAssertionResponseType response = this._wsSSOIdentityProvider.resolveAuthenticationAssertion(request);
            String string = response.getSsoSessionId();
            return string;
        }
        catch (AssertionNotValidErrorType e) {
            throw new AssertionNotValidException(e.getAssertionId());
        }
        catch (SSOIdentityProviderErrorType e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public void globalSignoff(String sessionId) throws IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[globalSignoff()] : " + sessionId));
            }
            GlobalSignoffRequestType request = new GlobalSignoffRequestType();
            request.setSsoSessionId(sessionId);
            GlobalSignoffResponseType globalSignoffResponseType = this._wsSSOIdentityProvider.globalSignoff(request);
        }
        catch (SSOIdentityProviderErrorType e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }
}

