/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.jaxws.identity.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.identity.exceptions.IdentityProvisioningException;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.ws._1_2.protocol.GlobalSignoffRequestType;
import org.josso.gateway.ws._1_2.protocol.GlobalSignoffResponseType;
import org.josso.gateway.ws._1_2.protocol.ResolveAuthenticationAssertionRequestType;
import org.josso.gateway.ws._1_2.protocol.ResolveAuthenticationAssertionResponseType;
import org.josso.gateway.ws._1_2.wsdl.AssertionNotValidErrorMessage;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProvider;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProviderErrorMessage;

public class WebserviceSSOIdentityProvider
implements SSOIdentityProviderService {
    private static final Log logger = LogFactory.getLog(WebserviceSSOIdentityProvider.class);
    private SSOIdentityProvider _wsSSOIdentityProvider;
    private int _errorCount;
    private int _processedCount;

    public WebserviceSSOIdentityProvider(SSOIdentityProvider wsSSOIdentityProvider) {
        this._wsSSOIdentityProvider = wsSSOIdentityProvider;
    }

    public void initialize() {
    }

    public String assertIdentityWithSimpleAuthentication(String requester, String securityDomain, String username, String password) throws IdentityProvisioningException {
        throw new UnsupportedOperationException("No JAX-WS implementation yet");
    }

    public String resolveAuthenticationAssertion(String requester, String authenticationAssertionId) throws AssertionNotValidException, IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[resolveAuthenticationAssertion()] : " + authenticationAssertionId));
            }
            ResolveAuthenticationAssertionRequestType request = new ResolveAuthenticationAssertionRequestType();
            request.setRequester(requester);
            request.setAssertionId(authenticationAssertionId);
            ResolveAuthenticationAssertionResponseType response = this._wsSSOIdentityProvider.resolveAuthenticationAssertion(request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[resolveAuthenticationAssertion('" + authenticationAssertionId + "')] : " + response.getSsoSessionId()));
            }
            String string = response.getSsoSessionId();
            return string;
        }
        catch (AssertionNotValidErrorMessage e) {
            throw new AssertionNotValidException(e.getFaultInfo().getAssertionId());
        }
        catch (SSOIdentityProviderErrorMessage e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public void globalSignoff(String requester, String sessionId) throws IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[globalSignoff()] : " + sessionId));
            }
            GlobalSignoffRequestType request = new GlobalSignoffRequestType();
            request.setRequester(requester);
            request.setSsoSessionId(sessionId);
            GlobalSignoffResponseType repsonse = this._wsSSOIdentityProvider.globalSignoff(request);
        }
        catch (SSOIdentityProviderErrorMessage e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }
}

