/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.SecurityDomain;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SSORequestImpl;
import org.josso.gateway.SSOWebConfiguration;
import org.josso.gateway.protocol.SSOProtocolManager;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.service.SSOSessionManager;

public class ProtocolHandlerFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(ProtocolHandlerFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            SSOProtocolManager pm;
            HttpServletRequest hreq = (HttpServletRequest)servletRequest;
            HttpServletResponse hres = (HttpServletResponse)servletResponse;
            SSOContext ctx = Lookup.getInstance().lookupSSOGateway().prepareSSOContext((SSORequest)new SSORequestImpl(hreq));
            SecurityDomain sd = ctx.getSecurityDomain();
            SSOWebConfiguration cfg = sd.getSSOWebConfiguration();
            if (cfg.isSendP3PHeader()) {
                if (!hres.isCommitted()) {
                    hres.setHeader("P3P", cfg.getP3PHeaderValue());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding P3P Header:" + cfg.getP3PHeaderValue()));
                    }
                } else {
                    logger.warn((Object)"Already commited response, cannot set P3P header");
                }
            }
            if (!this.existJossoSession(hreq, sd) && (pm = sd.getProtocolManager()) != null && !pm.dispatchRequest(hreq, hres)) {
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    protected boolean existJossoSession(HttpServletRequest request, SecurityDomain sd) throws Exception {
        block4: {
            String jossoSessionId = this.getJossoSessionId(request);
            if (jossoSessionId == null) {
                return false;
            }
            SSOSessionManager ssoSessionManager = sd.getSessionManager();
            try {
                SSOSession s = ssoSessionManager.getSession(jossoSessionId);
                if (s != null && s.isValid()) {
                    return true;
                }
            }
            catch (NoSuchSessionException nsse) {
                HttpSession ssn = request.getSession(true);
                if (ssn.getAttribute("ntlmHttpPa") == null) break block4;
                ssn.removeAttribute("ntlmHttpPa");
            }
        }
        return false;
    }

    protected String getJossoSessionId(HttpServletRequest request) {
        Cookie c = this.getJossoCookie(request);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }

    protected Cookie getJossoCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals("JOSSO_SESSIONID")) continue;
            return cookie;
        }
        return null;
    }
}

