/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.signon.SignonBaseAction;

public class InfoAction
extends SignonBaseAction {
    private static final Log logger = LogFactory.getLog(InfoAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String jossoSessionId;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("JOSSO Command : [cmd=" + this.getSSOCmd(request) + "]"));
        }
        if ((jossoSessionId = this.getJossoSessionId(request)) != null) {
            try {
                SSOGateway g = this.getSSOGateway();
                SSOUser user = g.findUserInSession(jossoSessionId);
                SSOSession session = g.findSession(jossoSessionId);
                SSORole[] roles = g.findRolesByUsername(user.getName());
                request.setAttribute("org.josso.gateway.user", (Object)user);
                request.setAttribute("org.josso.gateway.userRoles", (Object)roles);
                request.setAttribute("org.josso.gateway.session", (Object)session);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[execute()] stored user : " + user + " under key : " + "org.josso.gateway.user"));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[execute()] stored session : " + session + " under key : " + "org.josso.gateway.session"));
                }
            }
            catch (SSOException e) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return mapping.findForward("success");
    }
}

