/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.josso.Lookup;
import org.josso.SecurityDomain;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.SSOWebConfiguration;
import org.josso.gateway.assertion.AuthenticationAssertion;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.signon.SignonBaseAction;

public abstract class LoginAction
extends SignonBaseAction {
    public static final String JOSSO_CMD_LOGIN = "login";
    private static final Log logger = LogFactory.getLog(LoginAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("JOSSO Command : [cmd=" + this.getSSOCmd(request) + "]"));
        }
        this.prepareContext(request);
        String cmd = this.getSSOCmd(request);
        String backTo = this.getBackTo(request);
        if (backTo != null) {
            backTo = backTo.toLowerCase();
            SecurityDomain domain = SSOContext.getCurrent().getSecurityDomain();
            SSOWebConfiguration cfg = domain.getSSOWebConfiguration();
            boolean trusted = false;
            for (String trustedHost : cfg.getTrustedHosts()) {
                if (!backTo.startsWith("http://" + trustedHost) && !backTo.startsWith("https://" + trustedHost)) continue;
                trusted = true;
                break;
            }
            if (!trusted && cfg.getTrustedHosts().size() > 0) {
                logger.warn((Object)("Attempt to use untrusted host in back_to URL " + backTo));
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
                response.setStatus(403);
                return null;
            }
        }
        if (this.canRelay(request)) {
            return this.relay(mapping, form, request, response);
        }
        if (cmd == null) {
            return this.askForLogin(mapping, form, request, response);
        }
        return this.login(mapping, form, request, response);
    }

    protected ActionForward askForLogin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
            String loginUrl = cfg.getCustomLoginURL();
            if (loginUrl != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Redirecting to custom login : " + loginUrl));
                }
                response.sendRedirect(response.encodeRedirectURL(loginUrl));
                return null;
            }
            return mapping.findForward("login-page");
        }
        catch (Exception e) {
            if (this.onFatalError(e, request, response)) {
                return null;
            }
            return mapping.findForward("error");
        }
    }

    protected ActionForward login(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            SSOGateway gwy = this.getSSOGateway();
            Credential[] c = this.getCredentials(request);
            try {
                String back_to;
                SSOContext ctx = SSOContext.getCurrent();
                AuthenticationAssertion authAssertion = gwy.assertIdentity(c, ctx.getScheme());
                String sessionId = authAssertion.getSSOSessionId();
                SSOSession session = gwy.findSession(sessionId);
                this.storeSSOInformation(request, response, session);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"[login()], authentication successfull.");
                }
                if ((back_to = this.getBackTo(request, session, authAssertion)) == null) {
                    SSOUser user = gwy.findUserInSession(sessionId);
                    SSORole[] roles = gwy.findRolesByUsername(user.getName());
                    request.setAttribute("org.josso.gateway.session", (Object)session);
                    request.setAttribute("org.josso.gateway.user", (Object)user);
                    request.setAttribute("org.josso.gateway.userRoles", (Object)roles);
                    return mapping.findForward("login-result");
                }
                this.clearSSOParameters(request);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[login()], Redirecting user to : " + back_to));
                }
                response.sendRedirect(response.encodeRedirectURL(back_to));
                return null;
            }
            catch (AuthenticationFailureException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[AuthenticationFailureException] " + e.getMessage()), (Throwable)e);
                }
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("sso.login.failed"));
                this.saveErrors(request, errors);
                boolean ok = this.onLoginAuthenticationException(e, request, response, c);
                if (ok) {
                    return null;
                }
                return mapping.findForward("login-page");
            }
        }
        catch (Exception e) {
            if (this.onFatalError(e, request, response)) {
                return null;
            }
            return mapping.findForward("error");
        }
    }

    protected boolean onLoginAuthenticationException(AuthenticationFailureException e, HttpServletRequest request, HttpServletResponse response, Credential[] credentials) throws IOException {
        String cmd = this.getSSOCmd(request);
        if (cmd != null && cmd.equals("login_optional")) {
            String back_to = this.getBackTo(request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[login()], Login Optional failed, redirecting user to : " + back_to));
            }
            response.sendRedirect(response.encodeRedirectURL(back_to));
            return true;
        }
        String on_error = (String)request.getSession(true).getAttribute("org.josso.gateway.onErrorUrl");
        if (on_error == null) {
            try {
                SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
                on_error = cfg.getCustomLoginURL();
            }
            catch (Exception ex) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (on_error != null) {
            block9: {
                SSOGateway g = this.getSSOGateway();
                on_error = on_error + (on_error.indexOf("?") >= 0 ? "&" : "?") + "josso_error_type=" + e.getErrorType();
                try {
                    SSOContext ctx = SSOContext.getCurrent();
                    on_error = on_error + "&josso_username=" + g.getPrincipalName(ctx.getScheme(), credentials);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.error((Object)"  [onLoginAuthenticationException()] cant find PrincipalName");
                }
            }
            response.sendRedirect(response.encodeRedirectURL(on_error));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[login()], authentication failure. Redirecting user to : " + on_error));
            }
            return true;
        }
        return false;
    }

    protected ActionForward relay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String back_to;
            SSOGateway g = this.getSSOGateway();
            SSOSession session = SSOContext.getCurrent().getSession();
            AuthenticationAssertion authAssertion = g.assertIdentity(session.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[relay()], authentication successfull.");
            }
            if ((back_to = this.getBackTo(request, session, authAssertion)) == null) {
                return mapping.findForward("login-result");
            }
            this.clearSSOParameters(request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[relay()], Redirecting user to : " + back_to));
            }
            response.sendRedirect(response.encodeRedirectURL(back_to));
            return null;
        }
        catch (Exception e) {
            if (this.onFatalError(e, request, response)) {
                return null;
            }
            return mapping.findForward("error");
        }
    }

    protected boolean onFatalError(Exception e, HttpServletRequest request, HttpServletResponse response) {
        logger.error((Object)e.getMessage(), (Throwable)e);
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("sso.error", (Object)(e.getMessage() != null ? e.getMessage() : e.toString())));
        this.saveErrors(request, errors);
        return false;
    }

    protected boolean canRelay(HttpServletRequest request) {
        return SSOContext.getCurrent().getSession() != null;
    }
}

