/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOException;
import org.josso.gateway.signon.SignonBaseAction;

public class LoginSelectorAction
extends SignonBaseAction {
    private static final Log logger = LogFactory.getLog(LoginSelectorAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Cookie remembermeCookie;
        boolean clientAuth;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("JOSSO Command : [cmd=" + this.getSSOCmd(request) + "]"));
        }
        try {
            this.prepareContext(request);
        }
        catch (SSOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SSOAuthenticationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        boolean bl = clientAuth = request.getAttribute("javax.servlet.request.X509Certificate") != null;
        if (clientAuth) {
            ActionForward af = mapping.findForward("strong-authentication");
            String path = af.getPath();
            String host = request.getHeader("Host");
            String strongAuthLoginUrl = "https://" + host + path + "?josso_cmd=login" + (request.getQueryString() != null ? "&" + request.getQueryString() : "");
            try {
                logger.debug((Object)("Triggering 'strong-authentication'.  Redirecting to: " + strongAuthLoginUrl));
                response.sendRedirect(strongAuthLoginUrl);
                return null;
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        String remembermeCookieName = "JOSSO_REMEMBERME_" + SSOContext.getCurrent().getSecurityDomain().getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for cookie: JOSSO_REMEMBERME_" + SSOContext.getCurrent().getSecurityDomain().getName()));
        }
        if ((remembermeCookie = this.getCookie(request, remembermeCookieName)) != null && !remembermeCookie.getValue().equals("-")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"RemembermeCookie found!");
            }
            logger.debug((Object)"Triggering 'rememberme-authentication'");
            return mapping.findForward("rememberme-authentication");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"RemembermeCookie NOT found!");
        }
        boolean ntlmAuth = request.getHeader("Authorization") != null && request.getHeader("Authorization").startsWith("NTLM");
        boolean bl2 = ntlmAuth = ntlmAuth || request.getSession().getAttribute("ntlmHttpPa") != null;
        if (ntlmAuth) {
            try {
                logger.debug((Object)"Triggering 'ntlm-authentication'");
                return mapping.findForward("ntlm-authentication");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.debug((Object)"Triggering 'basic-authentication'");
        return mapping.findForward("basic-authentication");
    }
}

