/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.josso.Lookup;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.SSOWebConfiguration;
import org.josso.gateway.signon.SignonBaseAction;

public class LogoutAction
extends SignonBaseAction {
    private static final Log logger = LogFactory.getLog(LogoutAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("JOSSO Command : [cmd=" + this.getSSOCmd(request) + "]"));
        }
        try {
            SSOGateway g = this.getSSOGateway();
            this.prepareContext(request);
            g.logout();
            this.removeJossoSessionId(request, response);
        }
        catch (SSOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("sso.login.failed"));
            this.saveErrors(request, errors);
        }
        String back_to = request.getParameter("josso_back_to");
        if (back_to == null) {
            SSOWebConfiguration c = Lookup.getInstance().lookupSSOWebConfiguration();
            back_to = c.getLogoutBackToURL();
        }
        if (back_to != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[logout()], ok->redirecting to : " + back_to));
            }
            response.sendRedirect(response.encodeRedirectURL(back_to));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[logout()], ok");
        }
        return mapping.findForward("success");
    }
}

