/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.signon.LoginAction;

public class RememberMeLoginAction
extends LoginAction {
    private static Log logger = LogFactory.getLog(RememberMeLoginAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareContext(request);
        return this.login(mapping, form, request, response);
    }

    protected boolean onLoginAuthenticationException(AuthenticationFailureException e, HttpServletRequest request, HttpServletResponse response, Credential[] credentials) throws IOException {
        logger.debug((Object)"Removing cookie with 'JOSSO_REMEMBERME_TOKEN' (login auth exception)");
        Cookie ssoCookie = new Cookie("JOSSO_REMEMBERME_" + SSOContext.getCurrent().getSecurityDomain().getName(), "-");
        ssoCookie.setMaxAge(0);
        ssoCookie.setSecure(true);
        ssoCookie.setPath("/");
        response.addCookie(ssoCookie);
        return super.onLoginAuthenticationException(e, request, response, credentials);
    }

    protected boolean onFatalError(Exception e, HttpServletRequest request, HttpServletResponse response) {
        logger.debug((Object)"Removing cookie with 'JOSSO_REMEMBERME_TOKEN' (fatal error)");
        Cookie ssoCookie = new Cookie("JOSSO_REMEMBERME_" + SSOContext.getCurrent().getSecurityDomain().getName(), "-");
        ssoCookie.setMaxAge(0);
        ssoCookie.setSecure(true);
        ssoCookie.setPath("/");
        response.addCookie(ssoCookie);
        return super.onFatalError(e, request, response);
    }

    protected Credential[] getCredentials(HttpServletRequest request) throws SSOAuthenticationException {
        String cipherSuite = (String)request.getAttribute("javax.servlet.request.cipher_suite");
        if (cipherSuite == null) {
            logger.error((Object)"An SSL Connection is Required to perform Remember Me Authentication");
        }
        Cookie remembermeTokenCookie = this.getCookie(request, "JOSSO_REMEMBERME_" + SSOContext.getCurrent().getSecurityDomain().getName());
        String remembermeToken = remembermeTokenCookie.getValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found 'Remember Me' Token [" + remembermeToken + "]"));
        }
        if (remembermeToken != null && remembermeToken.length() >= 1) {
            SSOGateway g = this.getSSOGateway();
            Credential rememberme = g.newCredential(this.getSchemeName(request), "remembermeToken", (Object)remembermeToken);
            Credential[] c = new Credential[]{rememberme};
            return c;
        }
        logger.error((Object)"No Remember Me Token Received");
        return new Credential[0];
    }

    protected String getSchemeName(HttpServletRequest request) throws SSOAuthenticationException {
        return "rememberme-authentication";
    }
}

