/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.signon.Constants;

public class SSOContextListener
implements ServletContextListener,
Constants {
    private static final Log logger = LogFactory.getLog(SSOContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        try {
            Lookup lookup = Lookup.getInstance();
            lookup.init("josso-gateway-config.xml");
            lookup.lookupSSOGateway();
            ServletContext ctx = event.getServletContext();
            SSOGateway g = (SSOGateway)ctx.getAttribute("org.josso.gateway");
            if (g == null) {
                g = Lookup.getInstance().lookupSSOGateway();
                ctx.setAttribute("org.josso.gateway", (Object)g);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        SSOGateway g = (SSOGateway)event.getServletContext().getAttribute("org.josso.gateway");
        if (g != null) {
            g.destroy();
        }
    }
}

