/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.josso.Lookup;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.RememberMeAuthScheme;
import org.josso.gateway.MutableSSOContext;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SSORequestImpl;
import org.josso.gateway.SSOWebConfiguration;
import org.josso.gateway.assertion.AuthenticationAssertion;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.signon.Constants;

public abstract class SignonBaseAction
extends Action
implements Constants {
    private static final Log logger = LogFactory.getLog(SignonBaseAction.class);

    protected SSOGateway getSSOGateway() {
        SSOGateway g = (SSOGateway)this.getServlet().getServletContext().getAttribute("org.josso.gateway");
        if (g == null) {
            try {
                g = Lookup.getInstance().lookupSSOGateway();
                this.getServlet().getServletContext().setAttribute("org.josso.gateway", (Object)g);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot get Gateway instance " + e.getMessage()), (Throwable)e);
            }
        }
        return g;
    }

    protected String getSSOCmd(HttpServletRequest request) {
        String cmd = request.getParameter("josso_cmd");
        if ("".equals(cmd)) {
            cmd = null;
        }
        return cmd;
    }

    protected void prepareContext(HttpServletRequest request) throws SSOException, SSOAuthenticationException {
        MutableSSOContext ctx;
        block4: {
            String sessionId;
            this.storeSSOParameters(request);
            SSOGateway gwy = this.getSSOGateway();
            ctx = (MutableSSOContext)gwy.prepareSSOContext((SSORequest)new SSORequestImpl(request));
            ctx.setUserLocation(request.getRemoteHost());
            request.getSession().setAttribute("org.josso.gateway.securityDomainName", (Object)ctx.getSecurityDomain().getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[prepareContext()] Storing security domain name in session [org.josso.gateway.securityDomainName] : " + ctx.getSecurityDomain().getName() + " (" + request.getSession().getId() + ")"));
            }
            if ((sessionId = this.getJossoSessionId(request)) != null && !"".equals(sessionId)) {
                try {
                    ctx.setCurrentSession(gwy.findSession(sessionId));
                }
                catch (NoSuchSessionException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("NoSuchSessionException : " + sessionId + " " + e.getMessage()));
                }
            }
        }
        String scheme = this.getSchemeName(request);
        logger.debug((Object)("Using authentication scheme : " + scheme));
        ctx.setScheme(scheme);
    }

    protected void storeSSOParameters(HttpServletRequest request) {
        String on_error;
        HttpSession s = request.getSession(true);
        String back_to = request.getParameter("josso_back_to");
        if (back_to != null && !"".equals(back_to)) {
            s.setAttribute("org.josso.gateway.backToUrl", (Object)back_to);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[storeSSOParameters()] Storing back-to url in session [org.josso.gateway.backToUrl] : " + back_to + " (" + s.getId() + ")"));
            }
        }
        if ((on_error = request.getParameter("josso_on_error")) != null && !"".equals(on_error)) {
            s.setAttribute("org.josso.gateway.onErrorUrl", (Object)on_error);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[storeSSOParameters()] Storing on-error url in session [org.josso.gateway.onErrorUrl] : " + on_error + " (" + s.getId() + ")"));
            }
        }
    }

    protected void clearSSOParameters(HttpServletRequest req) {
        req.getSession().removeAttribute("org.josso.gateway.backToUrl");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[clearSSOParameters()] Removing org.josso.gateway.backToUrl from session (" + req.getSession().getId() + ")"));
        }
        req.getSession().removeAttribute("org.josso.gateway.onErrorUrl");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[clearSSOParameters()] Removing org.josso.gateway.onErrorUrl from session (" + req.getSession().getId() + ")"));
        }
        req.getSession().removeAttribute("org.josso.gateway.securityDomainName");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[clearSSOParameters()] Removing org.josso.gateway.securityDomainName from session (" + req.getSession().getId() + ")"));
        }
    }

    protected String getBackTo(HttpServletRequest request, SSOSession session, AuthenticationAssertion authAssertion) {
        String back_to;
        block6: {
            HttpSession httpSession = request.getSession();
            back_to = (String)httpSession.getAttribute("org.josso.gateway.backToUrl");
            if (back_to == null) {
                try {
                    SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  No 'BACK TO' URL found in session " + httpSession.getId()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  Using configured 'BACK TO' URL : " + cfg.getLoginBackToURL()));
                    }
                    back_to = cfg.getLoginBackToURL();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)"  [getBackTo()] cant find SSOWebConfiguration");
                }
            }
        }
        if (back_to == null) {
            logger.warn((Object)"No 'BACK TO' URL received or configured ... using default forward rule !");
            return null;
        }
        back_to = back_to + (back_to.indexOf("?") >= 0 ? "&" : "?") + "josso_assertion_id=" + authAssertion.getId();
        return back_to;
    }

    protected String getBackTo(HttpServletRequest request) {
        String back_to;
        block6: {
            HttpSession httpSession = request.getSession();
            back_to = (String)httpSession.getAttribute("org.josso.gateway.backToUrl");
            if (back_to == null) {
                try {
                    SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  No 'BACK TO' URL found in session " + httpSession.getId()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  Using configured 'BACK TO' URL : " + cfg.getLoginBackToURL()));
                    }
                    back_to = cfg.getLoginBackToURL();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)"  [getBackTo()] cant find SSOWebConfiguration");
                }
            }
        }
        if (back_to == null) {
            logger.warn((Object)"No 'BACK TO' URL received or configured ... using default forward rule !");
            return null;
        }
        return back_to;
    }

    protected Cookie getJossoCookie(HttpServletRequest request, String securityDomainName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals("JOSSO_SESSIONID_" + securityDomainName)) continue;
            return cookie;
        }
        return null;
    }

    protected Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    protected String getJossoSessionId(HttpServletRequest request) {
        String jossoSessionId;
        block4: {
            SSOContext ctx = SSOContext.getCurrent();
            jossoSessionId = null;
            try {
                SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
                if (cfg.isSessionTokenOnClient()) {
                    Cookie c = this.getJossoCookie(request, ctx.getSecurityDomain().getName());
                    if (c != null) {
                        jossoSessionId = c.getValue();
                    }
                    break block4;
                }
                HttpSession session = request.getSession();
                return (String)session.getAttribute("JOSSO_SESSIONID_" + ctx.getSecurityDomain().getName());
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"  [getJossoSessionId()] cant find SSOWebConfiguration");
            }
        }
        return jossoSessionId;
    }

    protected void storeSSOInformation(HttpServletRequest request, HttpServletResponse response, SSOSession session) {
        MutableSSOContext ctx = (MutableSSOContext)SSOContext.getCurrent();
        ctx.setCurrentSession(session);
        try {
            SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
            if (cfg.isSessionTokenOnClient()) {
                logger.debug((Object)"Storing SSO Session ID on clinet");
                Cookie ssoCookie = this.newJossoCookie(request.getContextPath(), "JOSSO_SESSIONID_" + ctx.getSecurityDomain().getName(), session.getId());
                response.addCookie(ssoCookie);
            } else {
                logger.debug((Object)"Storing SSO Session ID on server");
                HttpSession hsession = request.getSession();
                hsession.setAttribute("JOSSO_SESSIONID_" + ctx.getSecurityDomain().getName(), (Object)session.getId());
            }
            logger.debug((Object)("Remember Me:" + request.getParameter("josso_rememberme")));
            logger.debug((Object)("Command:" + request.getParameter("josso_cmd")));
            if (cfg.isRememberMeEnabled() && request.getParameter("josso_rememberme") != null) {
                logger.debug((Object)"Storing SSO Rememberme Token on Client");
                String cipherSuite = (String)request.getAttribute("javax.servlet.request.cipher_suite");
                if (cipherSuite == null) {
                    logger.error((Object)"SSL Required for 'remember me' feature");
                }
                RememberMeAuthScheme scheme = (RememberMeAuthScheme)ctx.getSecurityDomain().getAuthenticator().getAuthenticationScheme("rememberme-authentication");
                String token = scheme.getRemembermeTokenForUser(session.getUsername());
                Cookie rememberMeCookie = new Cookie("JOSSO_REMEMBERME_" + ctx.getSecurityDomain().getName(), token);
                rememberMeCookie.setMaxAge(60 * (cfg.getRememberMeMaxAge() > 0 ? cfg.getRememberMeMaxAge() : 525600));
                rememberMeCookie.setPath("/");
                if (cfg.isSessionTokenSecure()) {
                    rememberMeCookie.setSecure(true);
                } else {
                    logger.error((Object)"Remember Me funcion requires SSL Transport!");
                }
                response.addCookie(rememberMeCookie);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error while storing SSO Information : " + ex.getMessage()), (Throwable)ex);
        }
    }

    protected void removeJossoSessionId(HttpServletRequest request, HttpServletResponse response) {
        block5: {
            SSOContext ctx = SSOContext.getCurrent();
            try {
                SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
                if (cfg.isSessionTokenOnClient()) {
                    Cookie ssoCookie = this.newJossoCookie(request.getContextPath(), "JOSSO_SESSIONID_" + ctx.getSecurityDomain().getName(), "-");
                    ssoCookie.setMaxAge(0);
                    response.addCookie(ssoCookie);
                } else {
                    HttpSession session = request.getSession();
                    session.removeAttribute("JOSSO_SESSIONID_" + ctx.getSecurityDomain().getName());
                }
                if (cfg.isRememberMeEnabled()) {
                    Cookie rememberMeCookie = new Cookie("JOSSO_REMEMBERME_" + SSOContext.getCurrent().getSecurityDomain().getName(), "-");
                    rememberMeCookie.setMaxAge(0);
                    rememberMeCookie.setSecure(cfg.isSessionTokenSecure());
                    rememberMeCookie.setPath("/");
                    response.addCookie(rememberMeCookie);
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"  [removeJossoSessionId()] cant find SSOWebConfiguration");
            }
        }
    }

    protected Cookie newJossoCookie(String path, String name, String value) throws Exception {
        SSOWebConfiguration cfg = Lookup.getInstance().lookupSSOWebConfiguration();
        Cookie ssoCookie = new Cookie(name, value);
        ssoCookie.setMaxAge(-1);
        if (cfg.isSessionTokenSecure()) {
            ssoCookie.setSecure(true);
        }
        ssoCookie.setPath(path);
        return ssoCookie;
    }

    protected Credential[] getCredentials(HttpServletRequest request) throws SSOAuthenticationException {
        return new Credential[0];
    }

    protected String getSchemeName(HttpServletRequest request) throws SSOAuthenticationException {
        return "";
    }
}

