/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.signon;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.signon.LoginAction;

public class StrongLoginAction
extends LoginAction {
    private static final Log logger = LogFactory.getLog(StrongLoginAction.class);

    protected Credential[] getCredentials(HttpServletRequest request) throws SSOAuthenticationException {
        String cipherSuite = (String)request.getAttribute("javax.servlet.request.cipher_suite");
        if (cipherSuite != null) {
            X509Certificate[] certChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certChain != null && certChain.length >= 1) {
                SSOGateway g = this.getSSOGateway();
                Credential x509_certificate = g.newCredential(this.getSchemeName(request), "userCertificate", (Object)certChain[0]);
                Credential[] c = new Credential[]{x509_certificate};
                return c;
            }
            logger.error((Object)"No X.509 Certificate Received");
        } else {
            logger.error((Object)"An SSL Connection is Required to perform Strong Authentication");
        }
        return new Credential[0];
    }

    protected String getSchemeName(HttpServletRequest request) throws SSOAuthenticationException {
        return "strong-authentication";
    }
}

