/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.ws._1_1.wsdl.soapbinding;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.service.SSOSessionManager;
import org.josso.gateway.ws._1_1.protocol.FindRolesBySSOSessionIdRequestType;
import org.josso.gateway.ws._1_1.protocol.FindRolesBySSOSessionIdResponseType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSecurityDomainRequestType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSecurityDomainResponseType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSessionRequestType;
import org.josso.gateway.ws._1_1.protocol.FindUserInSessionResponseType;
import org.josso.gateway.ws._1_1.protocol.InvalidSessionErrorType;
import org.josso.gateway.ws._1_1.protocol.NoSuchUserErrorType;
import org.josso.gateway.ws._1_1.protocol.SSOIdentityManagerErrorType;
import org.josso.gateway.ws._1_1.protocol.SSONameValuePairType;
import org.josso.gateway.ws._1_1.protocol.SSORoleType;
import org.josso.gateway.ws._1_1.protocol.SSOUserType;
import org.josso.gateway.ws._1_1.protocol.UserExistsRequestType;
import org.josso.gateway.ws._1_1.protocol.UserExistsResponseType;
import org.josso.gateway.ws._1_1.wsdl.SSOIdentityManager;
import org.josso.gateway.ws._1_1.wsdl.soapbinding.BaseSSOService;

public class SSOIdentityManagerBindingImpl
extends BaseSSOService
implements SSOIdentityManager {
    private static final Log logger = LogFactory.getLog(SSOIdentityManagerBindingImpl.class);

    public FindUserInSessionResponseType findUserInSession(FindUserInSessionRequestType body) throws RemoteException {
        String ssoSessionId = body.getSsoSessionId();
        this.prepareCtx(SSOSessionManager.TOKEN_TYPE, ssoSessionId);
        SecurityDomain sd = SSOContext.getCurrent().getSecurityDomain();
        if (sd == null) {
            throw new InvalidSessionErrorType(ssoSessionId);
        }
        try {
            sd.getSessionManager().accessSession(ssoSessionId);
            SSOUser ssoUser = sd.getIdentityManager().findUserInSession(ssoSessionId);
            FindUserInSessionResponseType response = new FindUserInSessionResponseType();
            response.setSSOUser(this.toSSOUserType(ssoUser));
            return response;
        }
        catch (NoSuchSessionException e) {
            throw new InvalidSessionErrorType(ssoSessionId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityManagerErrorType("SSOIdentityManager error : " + e.getMessage());
        }
    }

    public FindUserInSecurityDomainResponseType findUserInSecurityDomain(FindUserInSecurityDomainRequestType body) throws RemoteException {
        try {
            String securityDomain = body.getSecurityDomain();
            this.prepareCtx(securityDomain);
            String username = body.getUsername();
            SSOUser user = SSOContext.getCurrent().getSecurityDomain().getIdentityManager().findUser(username);
            FindUserInSecurityDomainResponseType response = new FindUserInSecurityDomainResponseType();
            response.setSSOUser(this.toSSOUserType(user));
            return response;
        }
        catch (NoSuchUserException e) {
            NoSuchUserErrorType wsErr = new NoSuchUserErrorType();
            wsErr.setUsername(body.getUsername());
            wsErr.setSecurityDomain(body.getSecurityDomain());
            throw wsErr;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityManagerErrorType("SSOIdentityManager error : " + e.getMessage());
        }
    }

    public FindRolesBySSOSessionIdResponseType findRolesBySSOSessionId(FindRolesBySSOSessionIdRequestType body) throws RemoteException {
        String ssoSessionId = body.getSsoSessionId();
        this.prepareCtx(SSOSessionManager.TOKEN_TYPE, ssoSessionId);
        SecurityDomain sd = SSOContext.getCurrent().getSecurityDomain();
        if (sd == null) {
            throw new InvalidSessionErrorType(ssoSessionId);
        }
        try {
            sd.getSessionManager().accessSession(ssoSessionId);
            SSOUser user = sd.getIdentityManager().findUserInSession(ssoSessionId);
            SSORole[] roles = sd.getIdentityManager().findRolesByUsername(user.getName());
            SSORoleType[] roleTypes = this.adaptRoles(roles);
            FindRolesBySSOSessionIdResponseType response = new FindRolesBySSOSessionIdResponseType();
            response.setRoles(roleTypes);
            return response;
        }
        catch (NoSuchSessionException e) {
            throw new InvalidSessionErrorType(ssoSessionId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityManagerErrorType("SSOIdentityManager error : " + e.getMessage());
        }
    }

    public UserExistsResponseType userExists(UserExistsRequestType body) throws RemoteException {
        try {
            String securityDomain = body.getSecurityDomain();
            this.prepareCtx(securityDomain);
            UserExistsResponseType response = new UserExistsResponseType();
            try {
                SSOContext.getCurrent().getSecurityDomain().getIdentityManager().userExists(body.getUsername());
                response.setUserexists(true);
            }
            catch (NoSuchUserException e) {
                response.setUserexists(false);
            }
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityManagerErrorType("SSOIdentityManager error : " + e.getMessage());
        }
    }

    protected SSOUserType toSSOUserType(SSOUser user) {
        SSOContext cxt = SSOContext.getCurrent();
        SSOUserType userType = new SSOUserType();
        userType.setName(user.getName());
        userType.setSecuritydomain(cxt.getSecurityDomain().getName());
        SSONameValuePairType[] nvpts = this.adaptNameValuePairs(user.getProperties());
        userType.setProperties(nvpts);
        return userType;
    }

    protected SSONameValuePairType[] adaptNameValuePairs(SSONameValuePair[] nvps) {
        SSONameValuePairType[] nvpts = new SSONameValuePairType[nvps.length];
        for (int i = 0; i < nvps.length; ++i) {
            SSONameValuePairType nvpt;
            SSONameValuePair nvp = nvps[i];
            nvpts[i] = nvpt = this.adaptNameValuePair(nvp);
        }
        return nvpts;
    }

    protected SSONameValuePairType adaptNameValuePair(SSONameValuePair nvp) {
        SSONameValuePairType nvpt = new SSONameValuePairType();
        nvpt.setName(nvp.getName());
        nvpt.setValue(nvp.getValue());
        return nvpt;
    }

    protected SSORoleType[] adaptRoles(SSORole[] roles) {
        SSORoleType[] roleTypes = new SSORoleType[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            SSORole role = roles[i];
            roleTypes[i] = this.adaptRole(role);
        }
        return roleTypes;
    }

    protected SSORoleType adaptRole(SSORole r) {
        SSORoleType rt = new SSORoleType();
        rt.setName(r.getName());
        return rt;
    }
}

