/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password;

import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.josso.gateway.SSOContext;
import org.josso.selfservices.ChallengeResponseCredential;
import org.josso.selfservices.ProcessRequest;
import org.josso.selfservices.ProcessResponse;
import org.josso.selfservices.password.PasswordManagementService;
import org.josso.selfservices.password.SelfServicesBaseAction;
import org.josso.selfservices.password.lostpassword.LostPasswordProcessState;
import org.josso.selfservices.password.lostpassword.LostPasswordUrlProvider;

public class LostPasswordAction
extends SelfServicesBaseAction {
    public static final String JOSSO_CMD_CONFIRM_PASSWORD = "confirmPwd";
    public static final String JOSSO_CMD_LOST_PASSWORD = "lostPwd";
    public static final String PARAM_JOSSO_CMD = "josso_cmd";
    public static final String PARAM_JOSSO_PROCESS_ID = "josso_pidId";
    public static final String ATTR_LAST_PROCESS_RESPONSE = "org.josso.selfservices.lostpassword.processResponse";
    private static Log log = LogFactory.getLog(LostPasswordAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareContext(request);
        String josso_cmd = this.getSSOCmd(request);
        SSOContext ctx = SSOContext.getCurrent();
        PasswordManagementService pwdService = ctx.getSecurityDomain().getPasswordManager();
        HttpSession session = request.getSession();
        try {
            String processId = null;
            if (josso_cmd != null && josso_cmd.equals(JOSSO_CMD_LOST_PASSWORD)) {
                log.debug((Object)"Initializing lost password process");
                ProcessResponse pr = pwdService.startProcess("josso-simple-lostpassword");
                processId = pr.getProcessId();
                final String pid = pr.getProcessId();
                final String baseUrl = request.getScheme() + "://" + request.getHeader("Host") + request.getContextPath() + mapping.findForward("requestConfirmPassword").getPath() + "?josso_cmd=" + JOSSO_CMD_CONFIRM_PASSWORD;
                LostPasswordUrlProvider lostPaswordUrlProvider = new LostPasswordUrlProvider(){

                    public String provideResetUrl(String passwordAssertionId) {
                        return baseUrl + "&" + LostPasswordAction.PARAM_JOSSO_PROCESS_ID + "=" + pid + "&" + "josso_" + "pwdId" + "=" + passwordAssertionId;
                    }
                };
                pwdService.register(processId, "urlProvider", (Object)lostPaswordUrlProvider);
                log.debug((Object)("Process First Step (forward) : " + pr.getNextStep()));
                session.setAttribute(ATTR_LAST_PROCESS_RESPONSE, (Object)pr);
                return mapping.findForward(pr.getNextStep());
            }
            ProcessResponse pr = (ProcessResponse)session.getAttribute(ATTR_LAST_PROCESS_RESPONSE);
            if (pr == null) {
                processId = request.getParameter(PARAM_JOSSO_PROCESS_ID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using process id [" + processId + "] from session"));
                }
            } else {
                processId = pr.getProcessId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using process id [" + processId + "] from request"));
                }
            }
            ProcessRequest processRequest = pwdService.createRequest(processId);
            ChallengeResponseCredential[] challenges = this.fillChallengeResponses((LostPasswordProcessState)pwdService.getProcessState(processId), form, request);
            processRequest.setAttribute("challenges", (Object)challenges);
            ProcessResponse processResponse = pwdService.handleRequest(processRequest);
            session.setAttribute(ATTR_LAST_PROCESS_RESPONSE, (Object)processResponse);
            log.debug((Object)("Process Next Step (forward) : " + processResponse.getNextStep() + ". Final " + processResponse.isNextStepFinal()));
            if (processResponse.getNextStep().equals("fatalError") && processResponse.getAttribute("error") != null) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("sso.error", (Object)((Exception)processResponse.getAttribute("error")).getMessage()));
                this.saveErrors(request, errors);
            }
            return mapping.findForward(processResponse.getNextStep());
        }
        catch (Exception e) {
            log.error((Object)("Error recovering password : " + e.getMessage()), (Throwable)e);
            request.setAttribute("error", (Object)e);
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("sso.error", (Object)e.getMessage()));
            this.saveErrors(request, errors);
            return mapping.findForward("fatalError");
        }
    }

    protected ChallengeResponseCredential[] fillChallengeResponses(LostPasswordProcessState state, ActionForm form, HttpServletRequest request) {
        ArrayList<ChallengeResponseCredential> respondedChallenges = new ArrayList<ChallengeResponseCredential>();
        HttpSession session = request.getSession();
        ProcessResponse previousProcessResponse = (ProcessResponse)session.getAttribute(ATTR_LAST_PROCESS_RESPONSE);
        Set challenges = state.getChallenges();
        if (challenges == null || challenges.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No challenges requested");
            }
            return null;
        }
        for (ChallengeResponseCredential challenge : state.getChallenges()) {
            String challengeId = challenge.getId();
            String challengeResponse = request.getParameter(challengeId);
            if (challengeResponse == null) {
                challengeResponse = request.getParameter("josso_" + challengeId);
            }
            if (challengeResponse == null && form instanceof DynaActionForm) {
                DynaActionForm dForm = (DynaActionForm)form;
                try {
                    challengeResponse = (String)dForm.get(challengeId);
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)("Form does not have field " + challengeId));
                }
                if (challengeResponse == null) {
                    try {
                        challengeResponse = (String)dForm.get("josso_" + challengeId);
                    }
                    catch (IllegalArgumentException e) {
                        log.debug((Object)("Form does not have field " + challengeId));
                    }
                }
            }
            if (challengeResponse == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found response for challenge : " + challengeId));
            }
            challenge.setResponse(challengeResponse);
            respondedChallenges.add(challenge);
        }
        return respondedChallenges.toArray(new ChallengeResponseCredential[respondedChallenges.size()]);
    }

    protected String getSSOCmd(HttpServletRequest request) {
        String cmd = request.getParameter(PARAM_JOSSO_CMD);
        if ("".equals(cmd)) {
            cmd = null;
        }
        return cmd;
    }
}

