/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.josso.Lookup;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.MutableSSOContext;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SSORequestImpl;

public class SelfServicesBaseAction
extends Action {
    public static final String KEY_JOSSO_SECURITY_DOMAIN_NAME = "org.josso.gateway.securityDomainName";
    private static final Log logger = LogFactory.getLog(SelfServicesBaseAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareContext(request);
        return mapping.findForward("");
    }

    protected void prepareContext(HttpServletRequest request) throws SSOException, SSOAuthenticationException {
        SSOGateway gwy = this.getSSOGateway();
        MutableSSOContext ctx = (MutableSSOContext)gwy.prepareSSOContext((SSORequest)new SSORequestImpl(request));
        ctx.setUserLocation(request.getRemoteHost());
        request.getSession().setAttribute(KEY_JOSSO_SECURITY_DOMAIN_NAME, (Object)ctx.getSecurityDomain().getName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[prepareContext()] Storing security domain name in session [org.josso.gateway.securityDomainName] : " + ctx.getSecurityDomain().getName() + " (" + request.getSession().getId() + ")"));
        }
    }

    protected SSOGateway getSSOGateway() {
        try {
            return Lookup.getInstance().lookupSSOGateway();
        }
        catch (Exception e) {
            logger.error((Object)("Cannot get Gateway instance " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

