/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.SimplePrincipal;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AbstractAuthenticationScheme;
import org.josso.auth.scheme.RememberMeCredential;
import org.josso.auth.scheme.UsernameCredential;
import org.josso.auth.util.CipherUtil;

public class RememberMeAuthScheme
extends AbstractAuthenticationScheme {
    public static final String USERNAME_CREDENTIAL_NAME = "username";
    public static final String REMEMBER_ME_TOKEN_CREDENTIAL_NAME = "remembermeToken";
    private static final Log logger = LogFactory.getLog(RememberMeAuthScheme.class);
    private String base64Key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RememberMeAuthScheme() {
        this.setName("rememberme-authentication");
        Properties authProps = new Properties();
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/josso-auth.properties");
            if (is == null) {
                throw new IOException("Cannot find resource /josso-auth.properties.  Make sure this file is installed with JOSSO Gateway!");
            }
            authProps.load(is);
            this.base64Key = authProps.getProperty("josso.rememberme.authscheme.key");
            if (this.base64Key.equals("5FvzKCtKKjeqakdm4c89WA\\=\\=")) {
                logger.warn((Object)"Please, replace josso-auth.properties key! Do not use the one provided with the Gateway Archetype!");
            }
        }
        catch (IOException e) {
            logger.error((Object)("Cannot load auth properties : " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getName() {
        return this._name;
    }

    protected CredentialProvider doMakeCredentialProvider() {
        return this;
    }

    public Credential newCredential(String name, Object value) {
        if (name.equalsIgnoreCase(REMEMBER_ME_TOKEN_CREDENTIAL_NAME)) {
            return new RememberMeCredential(value);
        }
        if (name.equalsIgnoreCase(USERNAME_CREDENTIAL_NAME)) {
            return new UsernameCredential(value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unknown credential name : " + name));
        }
        return null;
    }

    public boolean authenticate() throws SSOAuthenticationException {
        this.setAuthenticated(false);
        String remembermeToken = this.getRemembermeToken(this._inputCredentials);
        if (remembermeToken == null || remembermeToken.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RememberMe Token" + (remembermeToken == null || remembermeToken.length() == 0 ? " not" : "") + " provided. "));
            }
            return false;
        }
        String username = this.getUsername(this._inputCredentials);
        if (username == null || username.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Username not " + (remembermeToken == null || remembermeToken.length() == 0 ? " not" : "") + " provided. "));
            }
            return false;
        }
        Credential[] knownCredentials = this.getKnownCredentials();
        String knownUsername = this.getUsername(knownCredentials);
        String knownRemembermeToken = this.getRemembermeToken(knownCredentials);
        if (!this.validateUsername(username, knownUsername) || !this.validateRememberMeToken(remembermeToken, knownRemembermeToken)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[authenticate()], Rememberme Token : " + remembermeToken));
        }
        this.setAuthenticated(true);
        return true;
    }

    protected Credential[] getKnownCredentials() throws SSOAuthenticationException {
        Credential[] creds = super.getKnownCredentials();
        Credential[] newCreds = new Credential[creds.length + 1];
        for (int i = 0; i < creds.length; ++i) {
            Credential cred = creds[i];
            newCreds[i] = creds[i];
        }
        newCreds[newCreds.length - 1] = this.getRememberMeCredential(this._inputCredentials);
        return newCreds;
    }

    public Principal getPrincipal() {
        return new SimplePrincipal(this.getUsername(this._inputCredentials));
    }

    public Principal getPrincipal(Credential[] credentials) {
        return new SimplePrincipal(this.getUsername(credentials));
    }

    public Credential[] getPrivateCredentials() {
        RememberMeCredential c = this.getRememberMeCredential(this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        Credential[] r = new Credential[]{c};
        return r;
    }

    public Credential[] getPublicCredentials() {
        RememberMeCredential c = this.getRememberMeCredential(this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        Credential[] r = new Credential[]{c};
        return r;
    }

    public void initialize(Credential[] userCredentials, Subject s) {
        super.initialize(userCredentials, s);
        RememberMeCredential rememberMe = this.getRememberMeCredential(userCredentials);
        if (rememberMe == null) {
            logger.warn((Object)"No remember me credential recevied");
            return;
        }
        String remembermeToken = (String)rememberMe.getValue();
        String username = this.getUsernameForToken(remembermeToken);
        if (username == null) {
            logger.debug((Object)"Username not provided, skiping UsernameCredential injection");
            return;
        }
        Credential usernameCred = this.doMakeCredentialProvider().newCredential(USERNAME_CREDENTIAL_NAME, (Object)username);
        this._inputCredentials = new Credential[this._inputCredentials.length + 1];
        for (int i = 0; i < userCredentials.length; ++i) {
            Credential userCredential;
            this._inputCredentials[i] = userCredential = userCredentials[i];
        }
        this._inputCredentials[this._inputCredentials.length - 1] = usernameCred;
    }

    public String getUsernameForToken(String remembermeToken) {
        try {
            String msg = CipherUtil.decryptAES((String)URLDecoder.decode(remembermeToken, "UTF-8"), (String)this.base64Key);
            return msg.substring("josso:".length());
        }
        catch (UnsupportedEncodingException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getRemembermeTokenForUser(String username) {
        try {
            String token = CipherUtil.encryptAES((String)("josso:" + username), (String)this.base64Key);
            return URLEncoder.encode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BadPaddingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    protected boolean validateUsername(String username, String knownUsername) {
        return username != null && knownUsername != null && username.length() > 0 && knownUsername.length() > 0 && username.equals(knownUsername);
    }

    protected boolean validateRememberMeToken(String rememberMeToken, String knownRememberMeToken) {
        return rememberMeToken != null && knownRememberMeToken != null && rememberMeToken.length() > 0 && knownRememberMeToken.length() > 0 && rememberMeToken.equals(knownRememberMeToken);
    }

    protected RememberMeCredential getRememberMeCredential(Credential[] credentials) {
        for (int i = 0; i < credentials.length; ++i) {
            if (!(credentials[i] instanceof RememberMeCredential)) continue;
            return (RememberMeCredential)credentials[i];
        }
        return null;
    }

    protected UsernameCredential getUsernameCredential(Credential[] credentials) {
        for (int i = 0; i < credentials.length; ++i) {
            if (!(credentials[i] instanceof UsernameCredential)) continue;
            return (UsernameCredential)credentials[i];
        }
        return null;
    }

    protected String getUsername(Credential[] creds) {
        UsernameCredential cred = this.getUsernameCredential(creds);
        if (cred == null) {
            return null;
        }
        return cred.getValue().toString();
    }

    protected String getRemembermeToken(Credential[] creds) {
        RememberMeCredential cred = this.getRememberMeCredential(creds);
        if (cred == null) {
            return null;
        }
        return cred.getValue().toString();
    }
}

