/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service.store;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.BaseSession;
import org.josso.gateway.session.service.store.MemorySessionStore;

public class SerializedSessionStore
extends MemorySessionStore {
    private static final Log logger = LogFactory.getLog(SerializedSessionStore.class);
    private HashMap _sessions;
    private boolean _loaded = false;
    private String _serializedFile = "sso_sessions.josso";

    public int getSize() throws SSOSessionException {
        this.checkLoad();
        return super.getSize();
    }

    public String[] keys() throws SSOSessionException {
        this.checkLoad();
        return super.keys();
    }

    public BaseSession[] loadAll() throws SSOSessionException {
        this.checkLoad();
        return super.loadAll();
    }

    public BaseSession load(String id) throws SSOSessionException {
        this.checkLoad();
        return super.load(id);
    }

    public BaseSession[] loadByUsername(String name) throws SSOSessionException {
        this.checkLoad();
        return super.loadByUsername(name);
    }

    public BaseSession[] loadByLastAccessTime(Date time) throws SSOSessionException {
        this.checkLoad();
        return super.loadByLastAccessTime(time);
    }

    public BaseSession[] loadByValid(boolean valid) throws SSOSessionException {
        this.checkLoad();
        return super.loadByValid(valid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) throws SSOSessionException {
        this.checkLoad();
        super.remove(id);
        SerializedSessionStore serializedSessionStore = this;
        synchronized (serializedSessionStore) {
            this._sessions.remove(id);
        }
        this.saveSerializedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws SSOSessionException {
        this.checkLoad();
        super.clear();
        SerializedSessionStore serializedSessionStore = this;
        synchronized (serializedSessionStore) {
            this._sessions.clear();
        }
        this.saveSerializedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BaseSession session) throws SSOSessionException {
        this.checkLoad();
        super.save(session);
        SerializedSessionStore serializedSessionStore = this;
        synchronized (serializedSessionStore) {
            this._sessions.put(session.getId(), session);
        }
        this.saveSerializedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSerializedSessions() throws SSOSessionException {
        try {
            FileOutputStream out = new FileOutputStream(this.getSerializedFile());
            ObjectOutputStream s = new ObjectOutputStream(out);
            SerializedSessionStore serializedSessionStore = this;
            synchronized (serializedSessionStore) {
                s.writeObject(this._sessions);
            }
            s.flush();
            s.close();
            out.close();
        }
        catch (IOException e) {
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkLoad() throws SSOSessionException {
        if (this._loaded) {
            return;
        }
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() throws SSOSessionException {
        if (this._loaded) {
            return;
        }
        FileInputStream in = null;
        ObjectInputStream s = null;
        logger.info((Object)("Loading serialized sessions from file : " + this.getSerializedFile()));
        try {
            in = new FileInputStream(this.getSerializedFile());
            s = new ObjectInputStream(in);
            this._sessions = (HashMap)s.readObject();
            for (BaseSession ssoSession : this._sessions.values()) {
                super.save(ssoSession);
            }
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[checkLoad()] FileNotFoundeException : " + this.getSerializedFile()));
            }
            this._sessions = new HashMap();
            this.saveSerializedSessions();
        }
        catch (Exception e) {
            logger.warn((Object)("Can't load serialized sessions from " + this.getSerializedFile() + " : " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
            this._sessions = new HashMap();
            this.saveSerializedSessions();
        }
        finally {
            block20: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block20;
                        logger.debug((Object)("I/O after loading ... " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            this._loaded = true;
        }
    }

    public void setSerializedFile(String serializedFile) {
        this._serializedFile = serializedFile;
    }

    public String getSerializedFile() {
        return this._serializedFile;
    }
}

