/*
 * Decompiled with CFR 0.152.
 */
package org.josso.servlet.agent;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.agent.http.JOSSOSecurityContext;
import org.josso.servlet.agent.GenericServletLocalSession;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;
import org.josso.servlet.agent.jaas.SSOGatewayHandler;

public class GenericServletSSOAgent
extends HttpSSOAgent {
    private static final Log log = LogFactory.getLog(GenericServletSSOAgent.class);

    public SingleSignOnEntry processRequest(SSOAgentRequest request) {
        GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
        GenericServletLocalSession localSession = (GenericServletLocalSession)r.getLocalSession();
        SingleSignOnEntry entry = super.processRequest(request);
        if (entry != null) {
            if (r.getSecurityContext() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing JOSSO Security Context instance in session [" + (entry != null ? entry.ssoId : "<NO-SSO-ID>") + "]"));
                }
                localSession.setSecurityContext(r.getSecurityContext());
            }
        } else if (localSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clearing JOSSO Security Context for session [" + localSession.getId() + "]"));
            }
            localSession.setSecurityContext(null);
            r.setSecurityContext(null);
        }
        return entry;
    }

    protected Principal authenticate(SSOAgentRequest request) {
        String ssoSessionId = request.getSessionId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting SSO Session authentication : " + ssoSessionId));
        }
        try {
            SSOGatewayHandler ch = new SSOGatewayHandler(ssoSessionId);
            LoginContext lc = new LoginContext("josso", ch);
            lc.login();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Session authenticated " + ssoSessionId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new JOSSO Security Context instance");
            }
            Subject s = lc.getSubject();
            GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
            JOSSOSecurityContext ctx = new JOSSOSecurityContext(s);
            r.setSecurityContext(ctx);
            return ctx.getCurrentPrincipal();
        }
        catch (LoginException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    protected boolean isAuthenticationAlwaysRequired() {
        return true;
    }

    protected void log(String message) {
        log.debug((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        log.debug((Object)message, throwable);
    }
}

