/*
 * Decompiled with CFR 0.152.
 */
package org.josso.servlet.agent;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgent;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.JOSSOSecurityContext;
import org.josso.agent.http.JaasHttpSSOAgent;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.servlet.agent.GenericServletLocalSession;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;

public class GenericServletSSOAgent
extends JaasHttpSSOAgent {
    private static final Log log = LogFactory.getLog(GenericServletSSOAgent.class);
    private boolean _disableJaas = false;

    protected SingleSignOnEntry execute(SSOAgentRequest request) {
        GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
        GenericServletLocalSession localSession = (GenericServletLocalSession)r.getLocalSession();
        SingleSignOnEntry entry = super.execute(request);
        if (entry != null) {
            if (r.getSecurityContext() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing JOSSO Security Context instance in session [" + (entry != null ? entry.ssoId : "<NO-SSO-ID>") + "]"));
                }
                localSession.setSecurityContext(r.getSecurityContext());
            }
        } else if (localSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clearing JOSSO Security Context for session [" + localSession.getId() + "]"));
            }
            localSession.setSecurityContext(null);
            r.setSecurityContext(null);
        }
        return entry;
    }

    protected Principal authenticate(SSOAgentRequest request) {
        String ssoSessionId = request.getSessionId();
        Principal ssoUser = null;
        if (this._disableJaas) {
            log.info((Object)("Requested authentication to gateway by " + request.getRequester() + " using sso session " + ssoSessionId));
            try {
                if (ssoSessionId == null) {
                    log.error((Object)("Session authentication failed : " + ssoSessionId));
                    return null;
                }
                SSOAgent agent = Lookup.getInstance().lookupSSOAgent();
                SSOIdentityManagerService im = agent.getSSOIdentityManager();
                if (request.getNodeId() == null && !"".equals(request.getNodeId())) {
                    im = agent.getSSOIdentityManager(request.getNodeId());
                }
                ssoUser = im.findUserInSession(request.getRequester(), ssoSessionId);
                log.info((Object)("Session authentication succeeded : " + ssoSessionId));
            }
            catch (SSOIdentityException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage());
                }
            }
            catch (Exception e) {
                log.error((Object)("Session authentication failed : " + ssoSessionId), (Throwable)e);
            }
        } else {
            ssoUser = super.authenticate(request);
        }
        if (ssoUser != null) {
            HashSet<Principal> principals = new HashSet<Principal>();
            principals.add(ssoUser);
            SSORole[] ssoRolePrincipals = this.getRoleSets(request.getRequester(), ssoSessionId, request.getNodeId());
            for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                principals.add((Principal)ssoRolePrincipals[i]);
                log.debug((Object)("Added SSORole Principal to the Subject : " + ssoRolePrincipals[i]));
            }
            Subject subject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
            GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
            JOSSOSecurityContext ctx = new JOSSOSecurityContext(subject);
            ctx.setSSOSession(ssoSessionId);
            r.setSecurityContext(ctx);
        }
        return ssoUser;
    }

    protected boolean isAuthenticationAlwaysRequired() {
        return true;
    }

    public boolean isDisableJaas() {
        return this._disableJaas;
    }

    public void setDisableJaas(boolean disableJaas) {
        this._disableJaas = disableJaas;
    }

    protected void log(String message) {
        log.info((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        log.info((Object)message, throwable);
    }
}

