/*
 * Decompiled with CFR 0.152.
 */
package org.josso.servlet.agent;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.LocalSession;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.servlet.agent.GenericServletLocalSession;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;

public class GenericServletSSOAgentFilter
implements Filter {
    public static final String KEY_SESSION_MAP = "org.josso.servlet.agent.sessionMap";
    public static final String LAZY_STARTUP = "lazy";
    protected ServletContext context;
    protected HttpSSOAgent agent;
    private static final Log log = LogFactory.getLog(GenericServletSSOAgentFilter.class);

    protected void startup() throws ServletException {
        try {
            Lookup lookup = Lookup.getInstance();
            lookup.init("josso-agent-config.xml");
            this.agent = (HttpSSOAgent)lookup.lookupSSOAgent();
            if (log.isDebugEnabled()) {
                this.agent.setDebug(1);
            }
            this.agent.start();
            this.context.setAttribute("org.josso.agent", (Object)this.agent);
        }
        catch (Exception e) {
            throw new ServletException("Error starting SSO Agent : " + e.getMessage(), (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        this.context.setAttribute(KEY_SESSION_MAP, new HashMap());
        if (this.agent == null && (filterConfig.getInitParameter("init") == null || filterConfig.getInitParameter("init") != null && !filterConfig.getInitParameter("init").equals(LAZY_STARTUP))) {
            this.startup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.agent == null) {
            this.startup();
        }
        HttpServletRequest hreq = (HttpServletRequest)request;
        HttpServletResponse hres = (HttpServletResponse)response;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing : " + hreq.getContextPath()));
        }
        try {
            Map<String, GenericServletLocalSession> sessionMap;
            String jossoSessionId;
            String contextPath = hreq.getContextPath();
            String vhost = hreq.getServerName();
            String nodeId = hreq.getParameter("josso_node");
            if (nodeId != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Storing JOSSO Node id : " + nodeId));
                }
                this.agent.setAttribute(hreq, hres, "JOSSO_NODE", nodeId);
            } else {
                nodeId = this.agent.getAttribute(hreq, "JOSSO_NODE");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found JOSSO Node id : " + nodeId));
                }
            }
            if ("".equals(contextPath)) {
                contextPath = "/";
            }
            if (!this.agent.isPartnerApp(vhost, contextPath)) {
                filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Context is not a josso partner app : " + hreq.getContextPath()));
                }
                return;
            }
            SSOPartnerAppConfig cfg = this.agent.getPartnerAppConfig(vhost, contextPath);
            if (cfg.isSendP3PHeader() && !hres.isCommitted()) {
                hres.setHeader("P3P", cfg.getP3PHeaderValue());
            }
            HttpSession session = hreq.getSession(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_login_request for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(this.agent.getJossoLoginUri()) || hreq.getRequestURI().endsWith(this.agent.getJossoUserLoginUri())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_login_request received for uri '" + hreq.getRequestURI() + "'"));
                }
                if (hreq.getRequestURI().endsWith(this.agent.getJossoUserLoginUri())) {
                    this.saveLoginBackToURL(hreq, hres, session, true);
                } else {
                    this.saveRequestURL(hreq, hres);
                }
                String loginUrl = this.agent.buildLoginUrl(hreq);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to login url '" + loginUrl + "'"));
                }
                this.agent.prepareNonCacheResponse(hres);
                hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_logout request for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(this.agent.getJossoLogoutUri())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_logout request received for uri '" + hreq.getRequestURI() + "'"));
                }
                String logoutUrl = this.agent.buildLogoutUrl(hreq, cfg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to logout url '" + logoutUrl + "'"));
                }
                Cookie ssoCookie = this.agent.newJossoCookie(hreq.getContextPath(), "-", hreq.isSecure());
                hres.addCookie(ssoCookie);
                session.invalidate();
                this.agent.prepareNonCacheResponse(hres);
                hres.sendRedirect(hres.encodeRedirectURL(logoutUrl));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Checking for SSO cookie");
            }
            Cookie cookie = null;
            Cookie[] cookies = hreq.getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            for (int i = 0; i < cookies.length; ++i) {
                if (!"JOSSO_SESSIONID".equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
            String string = jossoSessionId = cookie == null ? null : cookie.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session is:" + session));
            }
            if ((sessionMap = (Map<String, GenericServletLocalSession>)hreq.getSession().getServletContext().getAttribute(KEY_SESSION_MAP)) == null) {
                GenericServletSSOAgentFilter genericServletSSOAgentFilter = this;
                synchronized (genericServletSSOAgentFilter) {
                    sessionMap = (Map)hreq.getSession().getServletContext().getAttribute(KEY_SESSION_MAP);
                    if (sessionMap == null) {
                        sessionMap = Collections.synchronizedMap(new HashMap());
                        hreq.getSession().getServletContext().setAttribute(KEY_SESSION_MAP, sessionMap);
                    }
                }
            }
            GenericServletLocalSession localSession = (GenericServletLocalSession)sessionMap.get(session.getId());
            if (sessionMap.get(session.getId()) == null) {
                localSession = new GenericServletLocalSession(session);
                sessionMap.put(session.getId(), localSession);
            } else {
                localSession.updateSession(session);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_authentication for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(this.agent.getJossoAuthenticationUri())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_authentication received for uri '" + hreq.getRequestURI() + "'"));
                }
                GenericServletSSOAgentRequest customAuthRequest = (GenericServletSSOAgentRequest)this.doMakeSSOAgentRequest(cfg.getId(), 4, jossoSessionId, nodeId, localSession, null, hreq, hres);
                this.agent.processRequest((SSOAgentRequest)customAuthRequest);
                return;
            }
            if (cookie == null || cookie.getValue().equals("-")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSO cookie is not present, verifying optional login process ");
                }
                if (hreq.getRequestURI().endsWith(this.agent.getJossoSecurityCheckUri()) && hreq.getParameter("josso_assertion_id") == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.agent.getJossoSecurityCheckUri() + " received without assertion.  Login Optional Process failed"));
                    }
                    String requestURI = this.getSavedRequestURL(hreq);
                    this.agent.prepareNonCacheResponse(hres);
                    hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                    return;
                }
                if (!hreq.getRequestURI().endsWith(this.agent.getJossoSecurityCheckUri())) {
                    if (!this.agent.isResourceIgnored(cfg, hreq) && this.agent.isAutomaticLoginRequired(hreq, hres)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SSO cookie is not present, attempting automatic login");
                        }
                        this.saveRequestURL(hreq, hres);
                        String loginUrl = this.agent.buildLoginUrl(hreq);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Redirecting to login url '" + loginUrl + "'"));
                        }
                        this.agent.prepareNonCacheResponse(hres);
                        hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SSO cookie is not present, but login optional process is not required");
                    }
                    if (!this.agent.isResourceIgnored(cfg, hreq)) {
                        StringBuffer sb = new StringBuffer(hreq.getRequestURI());
                        if (hreq.getQueryString() != null) {
                            sb.append('?');
                            sb.append(hreq.getQueryString());
                        }
                        this.agent.setAttribute(hreq, hres, "JOSSO_SAVED_REQUEST", sb.toString());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSO cookie is not present, checking for outbound relaying");
                }
                if (!hreq.getRequestURI().endsWith(this.agent.getJossoSecurityCheckUri()) || hreq.getParameter("josso_assertion_id") == null) {
                    log.debug((Object)"SSO cookie not present and relaying was not requested, skipping");
                    filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
                    return;
                }
            }
            if (this.agent.isResourceIgnored(cfg, hreq)) {
                filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session is: " + session));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing agent...");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_security_check for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(this.agent.getJossoSecurityCheckUri()) && hreq.getParameter("josso_assertion_id") != null) {
                GenericServletSSOAgentRequest relayRequest;
                SingleSignOnEntry entry;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_security_check received for uri '" + hreq.getRequestURI() + "' assertion id '" + hreq.getParameter("josso_assertion_id")));
                }
                String assertionId = hreq.getParameter("josso_assertion_id");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Outbound relaying requested for assertion id [" + assertionId + "]"));
                }
                if ((entry = this.agent.processRequest((SSOAgentRequest)(relayRequest = (GenericServletSSOAgentRequest)this.doMakeSSOAgentRequest(cfg.getId(), 2, null, nodeId, localSession, assertionId, hreq, hres)))) == null) {
                    log.error((Object)("Outbound relaying failed for assertion id [" + assertionId + "], no Principal found."));
                    throw new ServletException("No Principal found. Verify your SSO Agent Configuration!");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Outbound relaying successful for assertion id [" + assertionId + "]"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Assertion id [" + assertionId + "] mapped to SSO session id [" + entry.ssoId + "]"));
                }
                cookie = this.agent.newJossoCookie(hreq.getContextPath(), entry.ssoId, hreq.isSecure());
                hres.addCookie(cookie);
                String requestURI = this.getSavedSplashResource(hreq);
                if (requestURI == null && (requestURI = this.getSavedRequestURL(hreq)) == null) {
                    requestURI = cfg.getDefaultResource() != null ? cfg.getDefaultResource() : hreq.getRequestURI().substring(0, hreq.getRequestURI().length() - this.agent.getJossoSecurityCheckUri().length());
                    String singlePointOfAccess = this.agent.getSinglePointOfAccess();
                    if (singlePointOfAccess != null) {
                        requestURI = singlePointOfAccess + requestURI;
                    } else {
                        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
                        if (reverseProxyHost != null) {
                            requestURI = reverseProxyHost + requestURI;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No saved request found, using : '" + requestURI + "'"));
                    }
                }
                this.clearSavedRequestURLs(hreq, hres);
                this.agent.clearAutomaticLoginReferer(hreq, hres);
                this.agent.prepareNonCacheResponse(hres);
                String postAuthURI = cfg.getPostAuthenticationResource();
                if (postAuthURI != null) {
                    String postAuthURL = this.agent.buildPostAuthUrl(hres, requestURI, postAuthURI);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to post-auth-resource '" + postAuthURL + "'"));
                    }
                    hres.sendRedirect(postAuthURL);
                } else if (!"".equals(requestURI)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to original '" + requestURI + "'"));
                    }
                    hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                } else {
                    log.debug((Object)("Redirecting to application's root context '" + contextPath));
                    hres.sendRedirect(hres.encodeRedirectURL(contextPath));
                }
                return;
            }
            SSOAgentRequest r = this.doMakeSSOAgentRequest(cfg.getId(), 1, jossoSessionId, nodeId, localSession, null, hreq, hres);
            SingleSignOnEntry entry = this.agent.processRequest(r);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executed agent.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Process request for '" + hreq.getRequestURI() + "'"));
            }
            if (entry != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Principal '" + entry.principal + "' has already been authenticated"));
                }
            } else {
                log.info((Object)"No Valid SSO Session, attempt an optional login?");
                if (cookie != null) {
                    cookie = this.agent.newJossoCookie(hreq.getContextPath(), "-", hreq.isSecure());
                    hres.addCookie(cookie);
                }
                if (cookie != null || this.getSavedRequestURL(hreq) == null && this.agent.isAutomaticLoginRequired(hreq, hres)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SSO Session is not valid, attempting automatic login");
                    }
                    this.saveRequestURL(hreq, hres);
                    String loginUrl = this.agent.buildLoginOptionalUrl(hreq);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to option login url '" + loginUrl + "'"));
                    }
                    this.agent.prepareNonCacheResponse(hres);
                    hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSO cookie is not present, but login optional process is not required");
                }
            }
            hreq.setAttribute("org.josso.agent.gateway-login-url", (Object)this.agent.getGatewayLoginUrl());
            hreq.setAttribute("org.josso.agent.gateway-logout-url", (Object)this.agent.getGatewayLogoutUrl());
            hreq.setAttribute("org.josso.agent.ssoSessionid", (Object)jossoSessionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Servlet Agent execution END");
            }
            filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed : " + hreq.getContextPath()));
            }
        }
    }

    public void destroy() {
        if (this.agent != null) {
            this.agent.stop();
            this.agent = null;
        }
    }

    private String getSavedSplashResource(HttpServletRequest hreq) {
        return this.agent.getAttribute(hreq, "josso_splash_resource");
    }

    private String getSavedRequestURL(HttpServletRequest hreq) {
        return this.agent.getAttribute(hreq, "JOSSO_SAVED_REQUEST");
    }

    protected SSOAgentRequest doMakeSSOAgentRequest(String requester, int action, String sessionId, String nodeId, LocalSession session, String assertionId, HttpServletRequest hreq, HttpServletResponse hres) {
        GenericServletSSOAgentRequest r = new GenericServletSSOAgentRequest(requester, action, sessionId, session, assertionId, nodeId);
        r.setRequest(hreq);
        r.setResponse(hres);
        return r;
    }

    private void saveRequestURL(HttpServletRequest hreq, HttpServletResponse hres) {
        StringBuffer sb = new StringBuffer(hreq.getRequestURI());
        if (hreq.getQueryString() != null) {
            String q = hreq.getQueryString();
            if (!q.startsWith("?")) {
                sb.append('?');
            }
            sb.append(q);
        }
        this.agent.setAttribute(hreq, hres, "JOSSO_SAVED_REQUEST", sb.toString());
    }

    protected void saveLoginBackToURL(HttpServletRequest request, HttpSession session, boolean overrideSavedResource) {
        this.saveLoginBackToURL(request, null, session, overrideSavedResource);
    }

    protected void saveLoginBackToURL(HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean overrideSavedResource) {
        String referer = request.getHeader("referer");
        if ((this.getSavedRequestURL(request) == null || overrideSavedResource) && referer != null && !referer.equals("")) {
            this.agent.setAttribute(request, response, "JOSSO_SAVED_REQUEST", referer);
        }
    }

    protected void clearSavedRequestURLs(HttpServletRequest hreq, HttpServletResponse hres) {
        this.agent.removeAttribute(hreq, hres, "JOSSO_SAVED_REQUEST");
        this.agent.removeAttribute(hreq, hres, "josso_splash_resource");
    }
}

