/*
 * Decompiled with CFR 0.152.
 */
package org.josso.spring.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.http.JOSSOSecurityContext;
import org.josso.agent.http.WebAccessControlUtil;
import org.josso.spring.security.JOSSOAuthenticationToken;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.web.filter.GenericFilterBean;

public class JOSSOAuthenticationFilter
extends GenericFilterBean {
    private static final Log logger = LogFactory.getLog(JOSSOAuthenticationFilter.class);
    private ApplicationEventPublisher eventPublisher;
    private UserDetailsService userDetailsService;
    private LogoutHandler[] handlers;

    public void afterPropertiesSet() {
        try {
            super.afterPropertiesSet();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        logger.debug((Object)"afterPropertiesSet() done");
    }

    public JOSSOAuthenticationFilter(LogoutHandler[] handlers) {
        this.handlers = handlers;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Non HTTP request unsupported by this filter");
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Non HTTP response unsupported by this filter");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        JOSSOSecurityContext sctx = WebAccessControlUtil.getSecurityContext((HttpServletRequest)request);
        logger.debug((Object)("Current JOSSO Security Context is " + sctx));
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication information already present : '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
            }
            if (sctx == null && authentication.isAuthenticated()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Logging out user '" + authentication + "'"));
                }
                for (int i = 0; i < this.handlers.length; ++i) {
                    this.handlers[i].logout(request, response, authentication);
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (sctx != null) {
            SavedRequest savedRequest = new HttpSessionRequestCache().getRequest(request, response);
            if (savedRequest != null) {
                logger.debug((Object)("Redirecting to original resource " + savedRequest.getRedirectUrl()));
            }
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(sctx.getSSOSession());
            JOSSOAuthenticationToken jossoAuth = new JOSSOAuthenticationToken(sctx.getSSOSession(), userDetails, userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)jossoAuth);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContextHolder populated with JOSSO Authentication Token: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
            }
            if (this.eventPublisher != null) {
                this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(SecurityContextHolder.getContext().getAuthentication(), ((Object)((Object)this)).getClass()));
            }
            if (savedRequest != null) {
                response.sendRedirect(savedRequest.getRedirectUrl());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No principal found in request !");
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

