/*
 * Decompiled with CFR 0.152.
 */
package org.josso.spring.security;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOSSOAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private Object principal;
    private String jossoSessionId;

    public JOSSOAuthenticationToken(String jossoSessionId, Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        if (principal == null || "".equals(principal) || jossoSessionId == null || "".equals(jossoSessionId)) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.principal = principal;
        this.jossoSessionId = jossoSessionId;
        this.setAuthenticated(true);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof JOSSOAuthenticationToken) {
            JOSSOAuthenticationToken test = (JOSSOAuthenticationToken)((Object)obj);
            return !this.getJossoSessionId().equals(test.getJossoSessionId());
        }
        return false;
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getJossoSessionId() {
        return this.jossoSessionId;
    }
}

