/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc50.agent;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.ValveContext;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.josso.agent.LocalSession;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.SingleSignOnEntry;
import org.josso.tc50.agent.CatalinaLocalSession;
import org.josso.tc50.agent.CatalinaSSOAgent;
import org.josso.tc50.agent.CatalinaSSOAgentRequest;

public class SSOAgentValve
extends ValveBase
implements Lifecycle,
SessionListener {
    protected int debug = 0;
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected boolean started = false;
    private CatalinaSSOAgent _agent;
    Map _sessionMap = Collections.synchronizedMap(new HashMap());

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void sessionEvent(SessionEvent event) {
        LocalSession localSession = (LocalSession)this._sessionMap.get(event.getSession().getId());
        if (event.getType().equals("destroySession")) {
            localSession.expire();
            this._sessionMap.remove(event.getSession().getId());
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("Agent already started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            Lookup lookup = Lookup.getInstance();
            lookup.init("josso-agent-config.xml");
            this._agent = (CatalinaSSOAgent)lookup.lookupSSOAgent();
            this._agent.setDebug(this.debug);
            this._agent.setCatalinaContainer(this.container);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            throw new LifecycleException("Error starting SSO Agent : " + e.getMessage());
        }
        this._agent.start();
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("Agent not started");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this._agent.stop();
        if (this.debug >= 1) {
            this.log("Stopped");
        }
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        if (this.debug >= 1) {
            this.log("Processing : " + hreq.getContextPath() + " [" + hreq.getRequestURL() + "]");
        }
        try {
            LocalSession localSession;
            String jossoSessionId;
            String contextPath = hreq.getContextPath();
            String vhost = hreq.getServerName();
            if ("".equals(contextPath)) {
                contextPath = "/";
            }
            if (!this._agent.isPartnerApp(vhost, contextPath)) {
                context.invokeNext(request, response);
                if (this.debug >= 1) {
                    this.log("Context is not a josso partner app : " + hreq.getContextPath());
                }
                return;
            }
            SSOPartnerAppConfig cfg = this._agent.getPartnerAppConfig(vhost, contextPath);
            if (cfg.isSendP3PHeader() && !hres.isCommitted()) {
                hres.setHeader("P3P", cfg.getP3PHeaderValue());
            }
            Session session = this.getSession((HttpRequest)request, true);
            String nodeId = hreq.getParameter("josso_node");
            if (nodeId != null) {
                if (this.debug >= 1) {
                    this.log("Storing JOSSO Node id : " + nodeId);
                }
                this._agent.setAttribute(hreq, hres, "JOSSO_NODE", nodeId);
            } else {
                nodeId = this._agent.getAttribute(hreq, "JOSSO_NODE");
                if (this.debug >= 1) {
                    this.log("Found JOSSO Node id : " + nodeId);
                }
            }
            if (this.debug >= 1) {
                this.log("Checking if its a josso_login_request for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith(this._agent.getJossoLoginUri()) || hreq.getRequestURI().endsWith(this._agent.getJossoUserLoginUri())) {
                if (this.debug >= 1) {
                    this.log("josso_login_request received for uri '" + hreq.getRequestURI() + "'");
                }
                if (hreq.getRequestURI().endsWith(this._agent.getJossoUserLoginUri())) {
                    this.saveLoginBackToURL(hreq, hres, session, true);
                } else {
                    this.saveLoginBackToURL(hreq, hres, session, false);
                }
                String loginUrl = this._agent.buildLoginUrl(hreq);
                if (this.debug >= 1) {
                    this.log("Redirecting to login url '" + loginUrl + "'");
                }
                this._agent.prepareNonCacheResponse(hres);
                hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                return;
            }
            if (this.debug >= 1) {
                this.log("Checking if its a josso_logout request for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith(this._agent.getJossoLogoutUri())) {
                if (this.debug >= 1) {
                    this.log("josso_logout request received for uri '" + hreq.getRequestURI() + "'");
                }
                String logoutUrl = this._agent.buildLogoutUrl(hreq, cfg);
                if (this.debug >= 1) {
                    this.log("Redirecting to logout url '" + logoutUrl + "'");
                }
                Cookie ssoCookie = this._agent.newJossoCookie(hreq.getContextPath(), "-", hreq.isSecure());
                hres.addCookie(ssoCookie);
                this._agent.prepareNonCacheResponse(hres);
                hres.sendRedirect(hres.encodeRedirectURL(logoutUrl));
                return;
            }
            if (this.debug >= 1) {
                this.log("Checking for SSO cookie");
            }
            Cookie cookie = null;
            Cookie[] cookies = hreq.getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            for (int i = 0; i < cookies.length; ++i) {
                if (!"JOSSO_SESSIONID".equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
            String string = jossoSessionId = cookie == null ? null : cookie.getValue();
            if (this.debug >= 1) {
                this.log("Session is: " + session);
            }
            if ((localSession = (LocalSession)this._sessionMap.get(session.getId())) == null) {
                localSession = new CatalinaLocalSession(session);
                session.addSessionListener((SessionListener)this);
                this._sessionMap.put(session.getId(), localSession);
            }
            if (this.debug >= 1) {
                this.log("Checking if its a josso_authentication for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith(this._agent.getJossoAuthenticationUri())) {
                if (this.debug >= 1) {
                    this.log("josso_authentication received for uri '" + hreq.getRequestURI() + "'");
                }
                CatalinaSSOAgentRequest customAuthRequest = new CatalinaSSOAgentRequest(cfg.getId(), 4, jossoSessionId, localSession);
                customAuthRequest.setRequest(hreq);
                customAuthRequest.setResponse(hres);
                customAuthRequest.setContext(request.getContext());
                this._agent.processRequest((SSOAgentRequest)customAuthRequest);
                return;
            }
            if (cookie == null || cookie.getValue().equals("-")) {
                if (this.debug >= 1) {
                    this.log("SSO cookie is not present, verifying optional login process ");
                }
                if (hreq.getRequestURI().endsWith(this._agent.getJossoSecurityCheckUri()) && hreq.getParameter("josso_assertion_id") == null) {
                    if (this.debug >= 1) {
                        this.log(this._agent.getJossoSecurityCheckUri() + " received without assertion.  Login Optional Process failed");
                    }
                    String requestURI = this.getSavedRequestURL(hreq, session);
                    this._agent.prepareNonCacheResponse(hres);
                    hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                    return;
                }
                if (!hreq.getRequestURI().endsWith(this._agent.getJossoSecurityCheckUri())) {
                    if (!this.isResourceIgnored(cfg, request) && this._agent.isAutomaticLoginRequired(hreq, hres)) {
                        if (this.debug >= 1) {
                            this.log("SSO cookie is not present, attempting automatic login");
                        }
                        this.saveRequest((HttpRequest)request, session);
                        String loginUrl = this._agent.buildLoginOptionalUrl(hreq);
                        if (this.debug >= 1) {
                            this.log("Redirecting to login url '" + loginUrl + "'");
                        }
                        this._agent.prepareNonCacheResponse(hres);
                        hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                        return;
                    }
                    if (this.debug >= 1) {
                        this.log("SSO cookie is not present, but login optional process is not required");
                    }
                    if (!this.isResourceIgnored(cfg, request)) {
                        StringBuffer sb = new StringBuffer(hreq.getRequestURI());
                        if (hreq.getQueryString() != null) {
                            sb.append('?');
                            sb.append(hreq.getQueryString());
                        }
                        this._agent.setAttribute(hreq, hres, "JOSSO_SAVED_REQUEST", sb.toString());
                    }
                }
                if (this.debug >= 1) {
                    this.log("SSO cookie is not present, checking for outbound relaying");
                }
                if (!hreq.getRequestURI().endsWith(this._agent.getJossoSecurityCheckUri()) || hreq.getParameter("josso_assertion_id") == null) {
                    this.log("SSO cookie not present and relaying was not requested, skipping");
                    context.invokeNext(request, response);
                    return;
                }
            }
            if (this.isResourceIgnored(cfg, request)) {
                context.invokeNext(request, response);
                return;
            }
            if (this.debug >= 1) {
                this.log("Session is: " + session);
            }
            if (this.debug >= 1) {
                this.log("Executing agent...");
            }
            this._agent.setCatalinaContainer((Container)request.getContext());
            if (this.debug >= 1) {
                this.log("Checking if its a josso_security_check for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith(this._agent.getJossoSecurityCheckUri()) && hreq.getParameter("josso_assertion_id") != null) {
                if (this.debug >= 1) {
                    this.log("josso_security_check received for uri '" + hreq.getRequestURI() + "' assertion id '" + hreq.getParameter("josso_assertion_id"));
                }
                String assertionId = hreq.getParameter("josso_assertion_id");
                if (this.debug >= 1) {
                    this.log("Outbound relaying requested for assertion id [" + assertionId + "]");
                }
                CatalinaSSOAgentRequest relayRequest = new CatalinaSSOAgentRequest(cfg.getId(), 2, null, localSession, assertionId);
                relayRequest.setRequest(hreq);
                relayRequest.setResponse(hres);
                relayRequest.setContext(request.getContext());
                SingleSignOnEntry entry = this._agent.processRequest((SSOAgentRequest)relayRequest);
                if (entry == null) {
                    if (this.debug >= 1) {
                        this.log("Outbound relaying failed for assertion id [" + assertionId + "], no Principal found.");
                    }
                    throw new RuntimeException("Outbound relaying failed. No Principal found. Verify your SSO Agent Configuration!");
                }
                if (this.debug >= 1) {
                    this.log("Outbound relaying succesfull for assertion id [" + assertionId + "]");
                }
                if (this.debug >= 1) {
                    this.log("Assertion id [" + assertionId + "] mapped to SSO session id [" + entry.ssoId + "]");
                }
                cookie = this._agent.newJossoCookie(hreq.getContextPath(), entry.ssoId, hreq.isSecure());
                hres.addCookie(cookie);
                String requestURI = this.getSavedSplashResource(hreq);
                if (requestURI == null && (requestURI = this.getSavedRequestURL(hreq, session)) == null) {
                    requestURI = cfg.getDefaultResource() != null ? cfg.getDefaultResource() : hreq.getRequestURI().substring(0, hreq.getRequestURI().length() - this._agent.getJossoSecurityCheckUri().length());
                    String singlePointOfAccess = this._agent.getSinglePointOfAccess();
                    if (singlePointOfAccess != null) {
                        requestURI = singlePointOfAccess + requestURI;
                    } else {
                        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
                        if (reverseProxyHost != null) {
                            requestURI = reverseProxyHost + requestURI;
                        }
                    }
                    if (this.debug >= 1) {
                        this.log("No saved request found, using : '" + requestURI + "'");
                    }
                }
                this.clearSavedRequestURLs(hreq, hres, session);
                this._agent.clearAutomaticLoginReferer(hreq, hres);
                this._agent.prepareNonCacheResponse(hres);
                String postAuthURI = cfg.getPostAuthenticationResource();
                if (postAuthURI != null) {
                    String postAuthURL = this._agent.buildPostAuthUrl(hres, requestURI, postAuthURI);
                    if (this.debug >= 1) {
                        this.log("Redirecting to post-auth-resource '" + postAuthURL + "'");
                    }
                    hres.sendRedirect(postAuthURL);
                } else {
                    if (this.debug >= 1) {
                        this.log("Redirecting to original '" + requestURI + "'");
                    }
                    hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                }
                return;
            }
            this.log("Creating Security Context for Session [" + session + "]");
            CatalinaSSOAgentRequest r = new CatalinaSSOAgentRequest(cfg.getId(), 1, jossoSessionId, localSession);
            r.setRequest(hreq);
            r.setResponse(hres);
            r.setContext(request.getContext());
            SingleSignOnEntry entry = this._agent.processRequest((SSOAgentRequest)r);
            if (this.debug >= 1) {
                this.log("Executed agent.");
            }
            if (this.debug >= 1) {
                this.log("Process request for '" + hreq.getRequestURI() + "'");
            }
            if (entry != null) {
                if (this.debug >= 1) {
                    this.log("Principal '" + entry.principal + "' has already been authenticated");
                }
                ((HttpRequest)request).setAuthType(entry.authType);
                ((HttpRequest)request).setUserPrincipal(entry.principal);
            } else {
                this.log("No Valid SSO Session, attempt an optional login?");
                if (cookie != null) {
                    cookie = this._agent.newJossoCookie(hreq.getContextPath(), "-", hreq.isSecure());
                    hres.addCookie(cookie);
                }
                if (cookie != null || this.getSavedRequestURL(hreq, session) == null && this._agent.isAutomaticLoginRequired(hreq, hres)) {
                    if (this.debug >= 1) {
                        this.log("SSO Session is not valid, attempting automatic login");
                    }
                    this.saveRequest((HttpRequest)request, session);
                    String loginUrl = this._agent.buildLoginOptionalUrl(hreq);
                    if (this.debug >= 1) {
                        this.log("Redirecting to login url '" + loginUrl + "'");
                    }
                    this._agent.prepareNonCacheResponse(hres);
                    hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                    return;
                }
                if (this.debug >= 1) {
                    this.log("SSO cookie is not present, but login optional process is not required");
                }
            }
            hreq.setAttribute("org.josso.agent.gateway-login-url", (Object)this._agent.getGatewayLoginUrl());
            hreq.setAttribute("org.josso.agent.gateway-logout-url", (Object)this._agent.getGatewayLogoutUrl());
            hreq.setAttribute("org.josso.agent.ssoSessionid", (Object)jossoSessionId);
            context.invokeNext(request, response);
        }
        catch (Throwable t) {
            hreq.setAttribute("javax.servlet.error.exception", (Object)t);
            response.setError();
            context.invokeNext(request, response);
            return;
        }
        finally {
            if (this.debug >= 1) {
                this.log("Processed : " + hreq.getContextPath() + " [" + hreq.getRequestURL() + "]");
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOn[");
        sb.append(this.container != null ? this.container.getName() : "");
        sb.append("]");
        return sb.toString();
    }

    protected Session getSession(HttpRequest request) {
        return this.getSession(request, false);
    }

    protected Session getSession(HttpRequest request, boolean create) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpSession hses = hreq.getSession(create);
        if (this.debug >= 1) {
            this.log("getSession() : hses " + hses);
        }
        if (hses == null) {
            return null;
        }
        Manager manager = request.getContext().getManager();
        if (this.debug >= 1) {
            this.log("getSession() : manager is " + manager);
        }
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(hses.getId());
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private String getSavedRequestURL(HttpServletRequest hreq, Session session) {
        String savedURL = this._agent.getAttribute(hreq, "JOSSO_SAVED_REQUEST");
        if (savedURL == null || savedURL.equals("")) {
            SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
            if (saved == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(saved.getRequestURI());
            if (saved.getQueryString() != null) {
                sb.append('?');
                sb.append(saved.getQueryString());
            }
            savedURL = sb.toString();
        }
        return savedURL;
    }

    private String getSavedSplashResource(HttpServletRequest hreq) {
        return this._agent.getAttribute(hreq, "josso_splash_resource");
    }

    private void saveRequest(HttpRequest request, Session session) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = hreq.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = hreq.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = hreq.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        Map parameters = hreq.getParameterMap();
        for (String paramName : parameters.keySet()) {
            String[] paramValues = (String[])parameters.get(paramName);
            saved.addParameter(paramName, paramValues);
        }
        saved.setMethod(hreq.getMethod());
        saved.setQueryString(hreq.getQueryString());
        saved.setRequestURI(hreq.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
        StringBuffer sb = new StringBuffer(hreq.getRequestURI());
        if (hreq.getQueryString() != null) {
            String q = hreq.getQueryString();
            if (!q.startsWith("?")) {
                sb.append('?');
            }
            sb.append(q);
        }
        this._agent.setAttribute(hreq, (HttpServletResponse)request.getResponse().getResponse(), "JOSSO_SAVED_REQUEST", sb.toString());
    }

    protected void saveLoginBackToURL(HttpServletRequest request, HttpServletResponse response, Session session, boolean overrideSavedResource) {
        String referer = request.getHeader("referer");
        String savedURL = this._agent.getAttribute(request, "JOSSO_SAVED_REQUEST");
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if ((savedURL == null && saved == null || overrideSavedResource) && referer != null && !referer.equals("")) {
            saved = new SavedRequest();
            int p = referer.indexOf("?");
            String uri = p >= 0 ? referer.substring(0, p) : referer;
            String queryStr = p >= 0 ? referer.substring(p) : null;
            saved.setRequestURI(uri);
            saved.setQueryString(queryStr);
            session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
            this._agent.setAttribute(request, response, "JOSSO_SAVED_REQUEST", referer);
        } else if (saved != null) {
            StringBuffer sb = new StringBuffer(saved.getRequestURI());
            if (saved.getQueryString() != null) {
                String q = saved.getQueryString();
                if (!q.startsWith("?")) {
                    sb.append('?');
                }
                sb.append(q);
            }
            this._agent.setAttribute(request, response, "JOSSO_SAVED_REQUEST", sb.toString());
        }
    }

    protected void clearSavedRequestURLs(HttpServletRequest hreq, HttpServletResponse hres, Session session) {
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        this._agent.removeAttribute(hreq, hres, "JOSSO_SAVED_REQUEST");
        this._agent.removeAttribute(hreq, hres, "josso_splash_resource");
    }

    protected boolean isResourceIgnored(SSOPartnerAppConfig cfg, Request request) {
        Realm realm;
        SecurityConstraint[] constraints;
        String[] ignoredWebResources = cfg.getIgnoredWebRources();
        if (this.debug >= 1) {
            this.log("Found [" + (ignoredWebResources != null ? ignoredWebResources.length + "" : "no") + "] ignored web resources ");
        }
        if (ignoredWebResources != null && ignoredWebResources.length > 0 && (constraints = (realm = request.getContext().getRealm()).findSecurityConstraints((HttpRequest)request, request.getContext())) != null) {
            for (int i = 0; i < ignoredWebResources.length; ++i) {
                String ignoredWebResource = ignoredWebResources[i];
                for (int j = 0; j < constraints.length; ++j) {
                    SecurityConstraint constraint = constraints[j];
                    if (constraint.findCollection(ignoredWebResource) == null) continue;
                    if (this.debug >= 1) {
                        this.log("Not subject to SSO protection :  web-resource-name:" + ignoredWebResource);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

