/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc70.agent;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.tc70.agent.jaas.CatalinaSSOUser;

public class CatalinaNativeRealm
extends RealmBase {
    private static Log log = LogFactory.getLog(CatalinaNativeRealm.class);
    protected static final String name = "CatalinaNativeRealm";

    public Principal authenticate(String username, String credentials) {
        try {
            SSOIdentityManagerService im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            String requester = "";
            SSOAgentRequest request = (SSOAgentRequest)AbstractSSOAgent._currentRequest.get();
            if (request != null) {
                requester = request.getRequester();
            } else {
                log.warn((Object)"No SSO Agent request found in thread local variable, can't identify requester");
            }
            SSOUser ssoUser = im.findUserInSession(requester, username);
            Principal principal = null;
            if (ssoUser != null) {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)ssoUser);
                SSORole[] ssoRolePrincipals = im.findRolesBySSOSessionId(requester, username);
                for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                    subject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                }
                principal = this.createPrincipal(username, subject);
            }
            return principal;
        }
        catch (SSOIdentityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Session authentication failed : " + username), (Throwable)e);
            throw new RuntimeException("Fatal error authenticating session : " + e);
        }
    }

    protected Principal createPrincipal(String username, Subject subject) {
        return CatalinaSSOUser.newInstance((Realm)this, subject);
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return this.authenticate(username, username);
    }
}

