/*
 * Decompiled with CFR 0.152.
 */
package org.josso.wls10.agent;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.LocalSession;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.gateway.session.exceptions.FatalSSOSessionException;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;
import org.josso.wls10.agent.WLSSSOAgent;

public class WLSSessionEnforcementServletFilter
implements Filter {
    private static final Log log = LogFactory.getLog(WLSSessionEnforcementServletFilter.class);
    private WLSSSOAgent _agent;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext ctx = filterConfig.getServletContext();
        if (this._agent == null) {
            try {
                Lookup lookup = Lookup.getInstance();
                lookup.init("josso-agent-config.xml");
                this._agent = (WLSSSOAgent)lookup.lookupSSOAgent();
                this._agent.start();
                if (log.isDebugEnabled()) {
                    this._agent.setDebug(1);
                }
            }
            catch (Exception e) {
                throw new ServletException("Error starting SSO Agent : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request;
        HttpServletResponse hres = (HttpServletResponse)response;
        HttpSession session = hreq.getSession(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing : " + hreq.getContextPath()));
        }
        String contextPath = hreq.getContextPath();
        String vhost = hreq.getServerName();
        SSOPartnerAppConfig cfg = this._agent.getPartnerAppConfig(vhost, contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JOSSO_SESSIONID".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie != null && !cookie.getValue().equals("-")) {
            String jossoSessionId = cookie.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("asserting SSO session for : " + jossoSessionId));
            }
            SSOAgentRequest sessionAssertionRequest = this.doMakeSSOAgentRequest(cfg.getId(), 3, jossoSessionId, null, null, hreq, hres);
            try {
                this._agent.processRequest(sessionAssertionRequest);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("asserted successfully SSO session for : " + jossoSessionId));
                }
            }
            catch (FatalSSOSessionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("error asserting SSO session : " + jossoSessionId));
                }
                Cookie ssoCookie = this._agent.newJossoCookie(hreq.getContextPath(), "-", hreq.isSecure());
                hres.addCookie(ssoCookie);
                session.invalidate();
                String requestedResourceUrl = this._agent.buildBackToURL(hreq, "");
                hres.sendRedirect(hres.encodeRedirectURL(requestedResourceUrl));
                return;
            }
        }
        filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
    }

    public void destroy() {
        if (this._agent != null) {
            this._agent.stop();
            this._agent = null;
        }
    }

    protected SSOAgentRequest doMakeSSOAgentRequest(String requester, int action, String sessionId, LocalSession session, String assertionId, HttpServletRequest hreq, HttpServletResponse hres) {
        GenericServletSSOAgentRequest r = new GenericServletSSOAgentRequest(requester, action, sessionId, session, assertionId);
        r.setRequest(hreq);
        r.setResponse(hres);
        return r;
    }
}

