/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityImpl;
import org.springframework.util.Assert;
import org.springframework.web.bind.RequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import sample.contact.Contact;
import sample.contact.ContactManager;

public class AdminPermissionController
implements Controller,
InitializingBean {
    private AclService aclService;
    private ContactManager contactManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contactManager, (String)"A ContactManager implementation is required");
        Assert.notNull((Object)this.aclService, (String)"An aclService implementation is required");
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int id = RequestUtils.getRequiredIntParameter((HttpServletRequest)request, (String)"contactId");
        Contact contact = this.contactManager.getById(new Long(id));
        Acl acl = this.aclService.readAclById((ObjectIdentity)new ObjectIdentityImpl((Object)contact));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("contact", contact);
        model.put("acl", acl);
        return new ModelAndView("adminPermission", "model", model);
    }

    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    public void setContactManager(ContactManager contact) {
        this.contactManager = contact;
    }
}

