/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.security.Authentication;
import org.springframework.security.acls.AccessControlEntry;
import org.springframework.security.acls.MutableAcl;
import org.springframework.security.acls.MutableAclService;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityImpl;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.util.Assert;
import sample.contact.Contact;
import sample.contact.ContactDao;
import sample.contact.ContactManager;

public class ContactManagerBackend
extends ApplicationObjectSupport
implements ContactManager,
InitializingBean {
    private ContactDao contactDao;
    private MutableAclService mutableAclService;
    private int counter = 1000;

    public void addPermission(Contact contact, Sid recipient, Permission permission) {
        MutableAcl acl;
        ObjectIdentityImpl oid = new ObjectIdentityImpl(Contact.class, (Serializable)contact.getId());
        try {
            acl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)oid);
        }
        catch (NotFoundException nfe) {
            acl = this.mutableAclService.createAcl((ObjectIdentity)oid);
        }
        acl.insertAce(acl.getEntries().length, permission, recipient, true);
        this.mutableAclService.updateAcl(acl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added permission " + permission + " for Sid " + recipient + " contact " + contact));
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contactDao, (String)"contactDao required");
        Assert.notNull((Object)this.mutableAclService, (String)"mutableAclService required");
    }

    public void create(Contact contact) {
        contact.setId(new Long(this.counter++));
        this.contactDao.create(contact);
        this.addPermission(contact, (Sid)new PrincipalSid(this.getUsername()), BasePermission.ADMINISTRATION);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created contact " + contact + " and granted admin permission to recipient " + this.getUsername()));
        }
    }

    public void delete(Contact contact) {
        this.contactDao.delete(contact.getId());
        ObjectIdentityImpl oid = new ObjectIdentityImpl(Contact.class, (Serializable)contact.getId());
        this.mutableAclService.deleteAcl((ObjectIdentity)oid, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted contact " + contact + " including ACL permissions"));
        }
    }

    public void deletePermission(Contact contact, Sid recipient, Permission permission) {
        ObjectIdentityImpl oid = new ObjectIdentityImpl(Contact.class, (Serializable)contact.getId());
        MutableAcl acl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)oid);
        AccessControlEntry[] entries = acl.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getSid().equals(recipient) || !entries[i].getPermission().equals(permission)) continue;
            acl.deleteAce(i);
        }
        this.mutableAclService.updateAcl(acl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted contact " + contact + " ACL permissions for recipient " + recipient));
        }
    }

    public List getAll() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Returning all contacts");
        }
        return this.contactDao.findAll();
    }

    public List getAllRecipients() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Returning all recipients");
        }
        List list = this.contactDao.findAllPrincipals();
        return list;
    }

    public Contact getById(Long id) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning contact with id: " + id));
        }
        return this.contactDao.getById(id);
    }

    public Contact getRandomContact() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Returning random contact");
        }
        Random rnd = new Random();
        List contacts = this.contactDao.findAll();
        int getNumber = rnd.nextInt(contacts.size());
        return (Contact)contacts.get(getNumber);
    }

    protected String getUsername() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal().toString();
    }

    public void setContactDao(ContactDao contactDao) {
        this.contactDao = contactDao;
    }

    public void setMutableAclService(MutableAclService mutableAclService) {
        this.mutableAclService = mutableAclService;
    }

    public void update(Contact contact) {
        this.contactDao.update(contact);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated contact " + contact));
        }
    }
}

