/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterCell;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="PCell", namespace="http://www.dmg.org/PMML-4_2")
public class PCell
extends ParameterCell
implements HasExtensions {
    @XmlAttribute(name="targetCategory")
    private String targetCategory;
    @XmlAttribute(name="parameterName", required=true)
    private String parameterName;
    @XmlAttribute(name="beta", required=true)
    private double beta;
    @XmlAttribute(name="df")
    private Integer df;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public PCell() {
    }

    public PCell(String parameterName, double beta) {
        this.parameterName = parameterName;
        this.beta = beta;
    }

    @Override
    public String getTargetCategory() {
        return this.targetCategory;
    }

    @Override
    public PCell setTargetCategory(String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public PCell setParameterName(String parameterName) {
        this.parameterName = parameterName;
        return this;
    }

    public double getBeta() {
        return this.beta;
    }

    public PCell setBeta(double beta) {
        this.beta = beta;
        return this;
    }

    public Integer getDf() {
        return this.df;
    }

    public PCell setDf(Integer df) {
        this.df = df;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public PCell addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

