/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dmg.pmml.ObjectFactory;
import org.dmg.pmml.PMML;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JAXBUtil {
    private static Schema schema = null;
    private static JAXBContext context = null;

    private JAXBUtil() {
    }

    public static SAXSource createFilteredSource(InputSource source, XMLFilter ... filters) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        for (XMLFilter filter : filters) {
            filter.setParent(reader);
            reader = filter;
        }
        SAXSource filteredSource = new SAXSource(reader, source);
        return filteredSource;
    }

    public static PMML unmarshalPMML(Source source) throws JAXBException {
        return (PMML)JAXBUtil.unmarshal(source);
    }

    public static Object unmarshal(Source source) throws JAXBException {
        Unmarshaller unmarshaller = JAXBUtil.createUnmarshaller();
        return unmarshaller.unmarshal(source);
    }

    public static void marshalPMML(PMML pmml, Result result) throws JAXBException {
        JAXBUtil.marshal(pmml, result);
    }

    public static void marshal(Object object, Result result) throws JAXBException {
        Marshaller marshaller = JAXBUtil.createMarshaller();
        marshaller.marshal(object, result);
    }

    public static Schema getSchema() throws IOException, SAXException {
        if (schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = ObjectFactory.class.getResource("/pmml.xsd");
            if (url == null) {
                throw new FileNotFoundException();
            }
            schema = schemaFactory.newSchema(url);
        }
        return schema;
    }

    public static JAXBContext getContext() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        return context;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = JAXBUtil.getContext();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBUtil.getContext();
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }
}

