/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.association;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.Itemset;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "localTransformations", "items", "itemsets", "associationRules", "modelVerification"})
@XmlRootElement(name="AssociationModel", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "numberOfTransactions", "maxNumberOfItemsPerTA", "avgNumberOfItemsPerTA", "minimumSupport", "minimumConfidence", "lengthLimit", "numberOfItems", "numberOfItemsets", "numberOfRules", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "localTransformations", "items", "itemsets", "associationRules", "modelVerification"})
public class AssociationModel
extends Model
implements HasExtensions<AssociationModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTransactions", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfTransactions")
    private Integer numberOfTransactions;
    @XmlAttribute(name="maxNumberOfItemsPerTA")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="maxNumberOfItemsPerTA")
    private Integer maxNumberOfItemsPerTA;
    @XmlAttribute(name="avgNumberOfItemsPerTA")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="avgNumberOfItemsPerTA")
    private Number avgNumberOfItemsPerTA;
    @XmlAttribute(name="minimumSupport", required=true)
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @JsonProperty(value="minimumSupport")
    private Number minimumSupport;
    @XmlAttribute(name="minimumConfidence", required=true)
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @JsonProperty(value="minimumConfidence")
    private Number minimumConfidence;
    @XmlAttribute(name="lengthLimit")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="lengthLimit")
    private Integer lengthLimit;
    @XmlAttribute(name="numberOfItems", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfItems")
    private Integer numberOfItems;
    @XmlAttribute(name="numberOfItemsets", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfItemsets")
    private Integer numberOfItemsets;
    @XmlAttribute(name="numberOfRules", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfRules")
    private Integer numberOfRules;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @org.jpmml.model.annotations.Extension
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="Item", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Item")
    private List<Item> items;
    @XmlElement(name="Itemset", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Itemset")
    private List<Itemset> itemsets;
    @XmlElement(name="AssociationRule", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="AssociationRule")
    private List<AssociationRule> associationRules;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67305489L;

    public AssociationModel() {
    }

    public AssociationModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="numberOfTransactions") Integer numberOfTransactions, @Property(value="minimumSupport") Number minimumSupport, @Property(value="minimumConfidence") Number minimumConfidence, @Property(value="numberOfItems") Integer numberOfItems, @Property(value="numberOfItemsets") Integer numberOfItemsets, @Property(value="numberOfRules") Integer numberOfRules, @Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.numberOfTransactions = numberOfTransactions;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfItemsets = numberOfItemsets;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public AssociationModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public AssociationModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public AssociationModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public AssociationModel setNumberOfTransactions(@Property(value="numberOfTransactions") Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTA() {
        return this.maxNumberOfItemsPerTA;
    }

    public AssociationModel setMaxNumberOfItemsPerTA(@Property(value="maxNumberOfItemsPerTA") Integer maxNumberOfItemsPerTA) {
        this.maxNumberOfItemsPerTA = maxNumberOfItemsPerTA;
        return this;
    }

    public Number getAvgNumberOfItemsPerTA() {
        return this.avgNumberOfItemsPerTA;
    }

    public AssociationModel setAvgNumberOfItemsPerTA(@Property(value="avgNumberOfItemsPerTA") Number avgNumberOfItemsPerTA) {
        this.avgNumberOfItemsPerTA = avgNumberOfItemsPerTA;
        return this;
    }

    public Number getMinimumSupport() {
        return this.minimumSupport;
    }

    public AssociationModel setMinimumSupport(@Property(value="minimumSupport") Number minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Number getMinimumConfidence() {
        return this.minimumConfidence;
    }

    public AssociationModel setMinimumConfidence(@Property(value="minimumConfidence") Number minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return this.lengthLimit;
    }

    public AssociationModel setLengthLimit(@Property(value="lengthLimit") Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public AssociationModel setNumberOfItems(@Property(value="numberOfItems") Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer getNumberOfItemsets() {
        return this.numberOfItemsets;
    }

    public AssociationModel setNumberOfItemsets(@Property(value="numberOfItemsets") Integer numberOfItemsets) {
        this.numberOfItemsets = numberOfItemsets;
        return this;
    }

    public Integer getNumberOfRules() {
        return this.numberOfRules;
    }

    public AssociationModel setNumberOfRules(@Property(value="numberOfRules") Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public AssociationModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public AssociationModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AssociationModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public AssociationModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public AssociationModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public AssociationModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public AssociationModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasItems() {
        return this.items != null && this.items.size() > 0;
    }

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        return this.items;
    }

    public AssociationModel addItems(Item ... items) {
        this.getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return this.itemsets != null && this.itemsets.size() > 0;
    }

    public List<Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public AssociationModel addItemsets(Itemset ... itemsets) {
        this.getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasAssociationRules() {
        return this.associationRules != null && this.associationRules.size() > 0;
    }

    public List<AssociationRule> getAssociationRules() {
        if (this.associationRules == null) {
            this.associationRules = new ArrayList<AssociationRule>();
        }
        return this.associationRules;
    }

    public AssociationModel addAssociationRules(AssociationRule ... associationRules) {
        this.getAssociationRules().addAll(Arrays.asList(associationRules));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public AssociationModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasItems()) {
                status = PMMLObject.traverse(visitor, this.getItems());
            }
            if (status == VisitorAction.CONTINUE && this.hasItemsets()) {
                status = PMMLObject.traverse(visitor, this.getItemsets());
            }
            if (status == VisitorAction.CONTINUE && this.hasAssociationRules()) {
                status = PMMLObject.traverse(visitor, this.getAssociationRules());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

