
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DiscreteNode", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedFields",
    "content"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonRootName("DiscreteNode")
@JsonPropertyOrder({
    "name",
    "count",
    "extensions",
    "derivedFields",
    "content"
})
public class DiscreteNode
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DiscreteNode>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private FieldName name;
    @XmlAttribute(name = "count")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("count")
    private Number count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DerivedField")
    private List<DerivedField> derivedFields;
    @XmlElements({
        @XmlElement(name = "DiscreteConditionalProbability", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.DiscreteConditionalProbability.class),
        @XmlElement(name = "ValueProbability", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.ValueProbability.class)
    })
    @JsonProperty("content")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "DiscreteConditionalProbability", value = org.dmg.pmml.bayesian_network.DiscreteConditionalProbability.class),
        @JsonSubTypes.Type(name = "ValueProbability", value = org.dmg.pmml.bayesian_network.ValueProbability.class)
    })
    private List<org.dmg.pmml.PMMLObject> content;
    private final static long serialVersionUID = 67371010L;

    public DiscreteNode() {
    }

    @ValueConstructor
    public DiscreteNode(
        @org.jpmml.model.annotations.Property("name")
        FieldName name,
        @org.jpmml.model.annotations.Property("content")
        List<org.dmg.pmml.PMMLObject> content) {
        this.name = name;
        this.content = content;
    }

    public FieldName getName() {
        return name;
    }

    public DiscreteNode setName(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    public Number getCount() {
        return count;
    }

    public DiscreteNode setCount(
        @org.jpmml.model.annotations.Property("count")
        Number count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DiscreteNode addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(this.derivedFields.size()> 0));
    }

    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<DerivedField>();
        }
        return this.derivedFields;
    }

    public DiscreteNode addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<org.dmg.pmml.PMMLObject>();
        }
        return this.content;
    }

    public DiscreteNode addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
