/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Enumerator::Generator"})
public class RubyGenerator
extends RubyObject {
    private RubyProc proc;
    private static ObjectAllocator GENERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyGenerator(runtime2, klass);
        }
    };

    public static RubyClass createGeneratorClass(Ruby runtime2) {
        RubyClass generatorc = runtime2.defineClassUnder("Generator", runtime2.getObject(), GENERATOR_ALLOCATOR, runtime2.getEnumerator());
        runtime2.setGenerator(generatorc);
        generatorc.index = 24;
        generatorc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyGenerator;
            }
        };
        generatorc.defineAnnotatedMethods(RubyGenerator.class);
        return generatorc;
    }

    public RubyGenerator(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyGenerator(Ruby runtime2) {
        super(runtime2, runtime2.getGenerator());
    }

    private void checkInit() {
        if (this.proc == null) {
            throw this.getRuntime().newArgumentError("uninitializer generator");
        }
    }

    private static RubyGenerator checkGenerator(IRubyObject obj) {
        if (!(obj instanceof RubyGenerator)) {
            throw obj.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass().getRealClass().getName() + " (expected Data)");
        }
        RubyGenerator generator = (RubyGenerator)obj;
        generator.checkInit();
        return generator;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            throw runtime2.newLocalJumpErrorNoBlock();
        }
        this.proc = runtime2.newProc(Block.Type.PROC, block);
        return this;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg2, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!(arg2 instanceof RubyProc)) {
            throw runtime2.newThreadError("wrong argument type " + arg2.getMetaClass() + " (expected Proc)");
        }
        if (block.isGiven()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        this.proc = (RubyProc)arg2;
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject obj) {
        this.proc = RubyGenerator.checkGenerator((IRubyObject)obj).proc;
        return this;
    }
}

