/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRange;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotNode
extends Node {
    private final Node beginNode;
    private final Node endNode;
    private final boolean exclusive;
    private final boolean isLiteral;

    public DotNode(ISourcePosition position, Node beginNode, Node endNode, boolean exclusive, boolean isLiteral) {
        super(position);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive;
        this.isLiteral = isLiteral;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.DOTNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDotNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return RubyRange.newRange(runtime2, context, this.beginNode.interpret(runtime2, context, self, aBlock), this.endNode.interpret(runtime2, context, self, aBlock), this.exclusive);
    }
}

