/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::AbstractInvoker"}, parent="Object")
public abstract class AbstractInvoker
extends RubyObject {
    static final String CLASS_NAME = "AbstractInvoker";
    protected final Arity arity;

    public static RubyClass createAbstractInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(CLASS_NAME, runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractInvoker.class);
        result.defineAnnotatedConstants(AbstractInvoker.class);
        return result;
    }

    protected AbstractInvoker(Ruby runtime2, int arity2) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME), arity2);
    }

    protected AbstractInvoker(Ruby runtime2, RubyClass klass, int arity2) {
        super(runtime2, klass);
        this.arity = Arity.fixed(arity2);
    }

    @JRubyMethod(name={"attach"})
    public IRubyObject attach(ThreadContext context, IRubyObject module, IRubyObject methodName) {
        if (!(module instanceof RubyModule)) {
            throw context.getRuntime().newTypeError(module, context.getRuntime().getModule());
        }
        DynamicMethod m = this.createDynamicMethod((RubyModule)module);
        ((RubyModule)module).addModuleFunction(methodName.asJavaString(), m);
        return this;
    }

    protected abstract DynamicMethod createDynamicMethod(RubyModule var1);

    public final Arity getArity() {
        return this.arity;
    }

    protected static final NativeParam[] getNativeParameterTypes(Ruby runtime2, RubyArray paramTypes) {
        NativeParam[] nativeParamTypes = new NativeParam[paramTypes.size()];
        for (int i = 0; i < paramTypes.size(); ++i) {
            IRubyObject obj = paramTypes.entry(i);
            nativeParamTypes[i] = obj instanceof NativeParam ? (NativeParam)((Object)obj) : NativeType.valueOf(obj);
            if (nativeParamTypes[i] != null) continue;
            throw runtime2.newArgumentError("Invalid parameter type");
        }
        return nativeParamTypes;
    }
}

