/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::MemoryPointer"}, parent="FFI::BasePointer")
public final class MemoryPointer
extends BasePointer {
    private static final Factory factory = Factory.getInstance();

    public static RubyClass createMemoryPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("MemoryPointer", module.getClass("BasePointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(MemoryPointer.class);
        result.defineAnnotatedConstants(MemoryPointer.class);
        return result;
    }

    private MemoryPointer(Ruby runtime2, IRubyObject klass, DirectMemoryIO io2, long total2, int typeSize) {
        super(runtime2, (RubyClass)klass, io2, total2, typeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IRubyObject allocate(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, int count2, boolean clear2, Block block) {
        int typeSize = MemoryPointer.calculateSize(context, sizeArg);
        int total2 = typeSize * count2;
        if (total2 < 0) {
            throw context.getRuntime().newArgumentError(String.format("Negative size (%d objects of %d size)", count2, typeSize));
        }
        AllocatedDirectMemoryIO io2 = factory.allocateDirectMemory(context.getRuntime(), total2 > 0 ? total2 : 1, clear2);
        if (io2 == null) {
            Ruby runtime2 = context.getRuntime();
            throw new RaiseException(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", typeSize, count2), true);
        }
        MemoryPointer ptr = new MemoryPointer(context.getRuntime(), recv2, (DirectMemoryIO)io2, (long)total2, typeSize);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, ptr);
                return iRubyObject;
            }
            finally {
                io2.free();
            }
        }
        return ptr;
    }

    static final MemoryPointer allocate(Ruby runtime2, int typeSize, int count2, boolean clear2) {
        int total2 = typeSize * count2;
        AllocatedDirectMemoryIO io2 = factory.allocateDirectMemory(runtime2, total2 > 0 ? total2 : 1, clear2);
        if (io2 == null) {
            throw new RaiseException(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", typeSize, count2), true);
        }
        return new MemoryPointer(runtime2, (IRubyObject)runtime2.fastGetModule("FFI").fastGetClass("MemoryPointer"), (DirectMemoryIO)io2, (long)total2, typeSize);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, Block block) {
        return MemoryPointer.allocate(context, recv2, sizeArg, 1, true, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject count2, Block block) {
        return MemoryPointer.allocate(context, recv2, sizeArg, RubyNumeric.fix2int(count2), true, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject count2, IRubyObject clear2, Block block) {
        return MemoryPointer.allocate(context, recv2, sizeArg, RubyNumeric.fix2int(count2), clear2.isTrue(), block);
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public final IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        return RubyString.newString(context.getRuntime(), String.format("MemoryPointer[address=%#x size=%d]", this.getAddress(), this.size));
    }

    @JRubyMethod(name={"inspect"})
    public final IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.getRuntime(), String.format("#<MemoryPointer address=%#x size=%d>", this.getAddress(), this.size));
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        ((AllocatedDirectMemoryIO)this.getMemoryIO()).free();
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        ((AllocatedDirectMemoryIO)this.getMemoryIO()).setAutoRelease(release.isTrue());
        return context.getRuntime().getNil();
    }
}

